/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.NumberAxis;
import javafx.util.StringConverter;

public class LongDisplayValueAxisFactory {
    public NumberAxis createLongDisplayValueAxis(ObservableValue<Contract> contract, PropertyType type) {
        NumberAxis axis = new NumberAxis("", -1.0, 1.0, 1.0);
        axis.setForceZeroInRange(false);
        axis.setAutoRanging(true);
        this.loadContract(axis, contract.getValue(), type);
        contract.addListener((observable2, oldValue, newValue) -> this.loadContract(axis, (Contract)newValue, type));
        axis.setAnimated(false);
        return axis;
    }

    private void loadContract(NumberAxis numberAxis, Contract contract, PropertyType propertyType) {
        if (contract != null) {
            Product product = contract.getProduct();
            numberAxis.setLabel(Util.getLabel(propertyType.labelKey, propertyType.unit.apply(product)));
            Integer decimalShift = propertyType.shift.apply(product);
            numberAxis.setTickLabelFormatter(new TickLabelFormatter(decimalShift));
            numberAxis.setTickUnit(Math.pow(10.0, decimalShift.intValue()));
        } else {
            numberAxis.setLabel(Util.getLabel(propertyType.labelKey, ""));
            numberAxis.setTickLabelFormatter(new TickLabelFormatter(0));
            numberAxis.setTickUnit(1.0);
        }
    }

    public static enum PropertyType {
        PRICE("chartPanel_prc_chart_y_axis_label", Product::getCurrencyCode, Product::getPriceDecimalShift),
        QUANTITY("chartPanel_qty_chart_y_axis_label", Product::getQuantityUnit, Product::getQuantityDecimalShift);

        private final String labelKey;
        private final Function<Product, String> unit;
        private final Function<Product, Integer> shift;

        private PropertyType(String labelKey, Function<Product, String> unit, Function<Product, Integer> shift) {
            this.labelKey = labelKey;
            this.unit = unit;
            this.shift = shift;
        }
    }

    private static class TickLabelFormatter
    extends StringConverter<Number> {
        private final int shift;

        private TickLabelFormatter(int shift) {
            this.shift = shift;
        }

        @Override
        public String toString(Number object) {
            return new LongDisplayValue(object.longValue(), this.shift).toString();
        }

        @Override
        public Number fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

