/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ShuttleSelectionField;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class ContractShuttleSelectionField
extends ShuttleSelectionField<Contract> {
    private final ObjectProperty<Product> product;
    private final ContractQueries contractQueries;

    public ContractShuttleSelectionField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ContractShuttleSelectionField(ApplicationContext appContext) {
        this.contractQueries = appContext.getService(ContractQueries.class);
        this.product = new SimpleObjectProperty<Product>();
        this.product.addListener((observable2, oldValue, newValue) -> this.productChanged((Product)newValue));
    }

    private void productChanged(Product newValue) {
        this.getAllItems().clear();
        if (newValue != null) {
            List<Contract> contracts = this.contractQueries.findPossibleUnderlyingContracts((Product)this.product.getValue()).getAll().filter(contract -> contract.getCompoundStatus().getContractStatus().isActive()).toList();
            this.getAllItems().setAll(contracts);
        }
    }

    public ObjectProperty<Product> productProperty() {
        return this.product;
    }
}

