/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;

public class DirectionToggle
extends HBox {
    @FXML
    private ToggleButton buyButton;
    @FXML
    private ToggleButton sellButton;
    @FXML
    private ToggleGroup toggleGroup;
    private final ObjectProperty<Direction> value;

    public DirectionToggle() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public DirectionToggle(ApplicationContext applicationContext) {
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
        this.value = new SimpleObjectProperty<Direction>(Direction.BUY);
        this.buyButton.disableProperty().bind(this.disableProperty());
        this.sellButton.disableProperty().bind(this.disableProperty());
        this.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            this.buyButton.setSelected(newValue == Direction.BUY);
            this.sellButton.setSelected(newValue == Direction.SELL);
        });
    }

    @FXML
    public void buyClick() {
        this.value.setValue(Direction.BUY);
        if (!this.buyButton.isSelected()) {
            this.buyButton.setSelected(true);
        }
    }

    @FXML
    public void sellClick() {
        this.value.setValue(Direction.SELL);
        if (!this.sellButton.isSelected()) {
            this.sellButton.setSelected(true);
        }
    }

    public Direction getValue() {
        return (Direction)this.value.get();
    }

    public void setValue(Direction value) {
        this.value.setValue(value);
    }

    public ObjectProperty<Direction> valueProperty() {
        return this.value;
    }

    public ToggleButton getBuyButton() {
        return this.buyButton;
    }

    public ToggleButton getSellButton() {
        return this.sellButton;
    }
}

