/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.CurrentTradingLimitQueries;
import com.deutscheboerse.comxerv.comtrader.entities.CurrentTradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.util.Pair;

public class TradingLimitToolbarNode
extends HBox
implements BottomToolbarNode,
LabeledBottomToolbarNode,
Destroyable {
    private final Label tradingLimitLabel;
    private final Label value;
    private final UserService userService;
    private final BooleanProperty showLabel = new SimpleBooleanProperty(true);
    private final CurrentTradingLimitQueries currentTradingLimitQueries;
    private final ObservableValue<User> currentUser;
    private final AbstractDataModelListener<CurrentTradingLimit> tradingLimitDataModelListener;
    private final InvalidationListener userChanged;

    public TradingLimitToolbarNode() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public TradingLimitToolbarNode(ApplicationContext applicationContext) {
        this.userService = applicationContext.getService(UserService.class);
        this.currentTradingLimitQueries = applicationContext.getService(CurrentTradingLimitQueries.class);
        this.tradingLimitLabel = new Label(Util.getLabel("commons_tradingLimit_colon"));
        this.value = new Label();
        this.getChildren().add(this.tradingLimitLabel);
        this.getChildren().add(this.value);
        this.showLabel.addListener((observable1, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.getChildren().add(0, this.tradingLimitLabel);
            } else {
                this.getChildren().remove(this.tradingLimitLabel);
            }
        });
        TooltipUtils.setTooltip(this.tradingLimitLabel, this.getDescription());
        TooltipUtils.setTooltip(this.value, this.getDescription());
        this.tradingLimitDataModelListener = new AbstractDataModelListener<CurrentTradingLimit>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(CurrentTradingLimit tradingLimit) {
                TradingLimitToolbarNode.this.setTradingLimit();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(CurrentTradingLimit object) {
                TradingLimitToolbarNode.this.setTradingLimit();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                TradingLimitToolbarNode.this.setTradingLimit();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        applicationContext.getSmallDataModel(CurrentTradingLimit.class).registerListener(new WeakDataModelListener<CurrentTradingLimit>(this.tradingLimitDataModelListener));
        this.currentUser = applicationContext.getService(UserService.class).currentUserProperty();
        this.userChanged = observable2 -> this.setTradingLimit();
        this.currentUser.addListener(new WeakInvalidationListener(this.userChanged));
        this.setTradingLimit();
    }

    private void setTradingLimit() {
        this.value.textProperty().unbind();
        this.value.setText("");
        if (this.userService.currentUserProperty().get() == null) {
            return;
        }
        User user = (User)this.userService.currentUserProperty().get();
        List<Pair> collect = this.currentTradingLimitQueries.findByMemberId(user.getMemberId()).getAll().map(l -> new Pair<ObjectProperty<LongDisplayValue>, String>(l.valueProperty(), l.getCurrency())).toList();
        ArrayList<Object> concat = new ArrayList<Object>();
        for (Pair p : collect) {
            if (collect.indexOf(p) != 0) {
                concat.add(", ");
            }
            concat.add(((ObjectProperty)p.getKey()).asString());
            concat.add(" ");
            concat.add(p.getValue());
        }
        this.value.textProperty().bind(Bindings.concat(concat.toArray()));
    }

    @Override
    public Node getPreviewForConfigTable() {
        Label proxyLabel = new Label();
        proxyLabel.setText(this.tradingLimitLabel.getText());
        proxyLabel.getStyleClass().addAll((Collection<String>)this.getStyleClass());
        proxyLabel.setDisable(true);
        return proxyLabel;
    }

    protected Label getValue() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_mainPanel_tradingLimitToolbarItem");
    }

    @Override
    public boolean isShowLabel() {
        return this.showLabel.get();
    }

    @Override
    public BooleanProperty showLabelProperty() {
        return this.showLabel;
    }

    @Override
    public void setShowLabel(boolean showLabel) {
        this.showLabel.set(showLabel);
    }

    @Override
    public void destroy() {
        this.value.textProperty().unbind();
    }
}

