/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.column;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column.DisplayNameColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column.FilterableTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.domain.ActiveContractDomain;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.domain.ContractDomain;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.ContractCellFactory;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.control.table.PropertyPathValueFactory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;

public class ContractColumn<S extends BroadcastEntity>
extends FilterableTableColumn<S, Contract, String> {
    private final PropertyPathValueFactory<S, Contract> cellValueFactory;
    private final ContractCellFactory<S> cellFactory;
    private BooleanProperty showAllContracts = new SimpleBooleanProperty(false);

    public ContractColumn() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected ContractColumn(ApplicationContext applicationContext) {
        this.setId("contractColumn");
        this.setLabelText(Util.getLabel("commons_contractShort"));
        this.setTooltipText(Util.getLabel("commons_contract"));
        this.setMinWidth(15.0);
        this.setPrefWidth(100.0);
        DisplayNameColumnFilter columnFilter = new DisplayNameColumnFilter();
        columnFilter.setFilterDomain(new ActiveContractDomain(applicationContext));
        this.showAllContracts = new SimpleBooleanProperty();
        this.showAllContracts.addListener((observable2, oldValue, newValue) -> columnFilter.setFilterDomain(newValue != false ? new ContractDomain(applicationContext) : new ActiveContractDomain(applicationContext)));
        this.setColumnFilter(columnFilter);
        this.cellValueFactory = new PropertyPathValueFactory();
        this.cellFactory = new ContractCellFactory();
        this.cellFactory.setAlignment(Pos.CENTER_LEFT);
        this.setCellValueFactory(this.cellValueFactory);
        this.setCellFactory(this.cellFactory);
        this.setComparator(Contract.DEFAULT_COMPARATOR);
    }

    public String getFxPropertyPath() {
        return this.cellValueFactory.getFxPropertyPath();
    }

    public void setFxPropertyPath(String fxPropertyPath) {
        this.cellValueFactory.setFxPropertyPath(fxPropertyPath);
    }

    public Pos getAlignment() {
        return this.cellFactory.getAlignment();
    }

    public void setAlignment(Pos pos) {
        this.cellFactory.setAlignment(pos);
    }

    public Boolean getShowAllContracts() {
        return this.showAllContracts.get();
    }

    public void setShowAllContracts(Boolean value) {
        this.showAllContracts.setValue(value);
    }

    public BooleanProperty showAllContractsProperty() {
        return this.showAllContracts;
    }
}

