/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.effect;

import javafx.beans.property.BooleanProperty;
import javafx.event.EventHandler;
import javafx.scene.layout.Pane;

public class CollapseExpandEffect {
    private final Pane container;
    private final Pane collapsible;
    private final BooleanProperty expanded;
    private final Pane placeholder;

    public CollapseExpandEffect(Pane container, Pane collapsible, BooleanProperty expanded) {
        this.container = container;
        this.collapsible = collapsible;
        this.expanded = expanded;
        this.placeholder = new Pane();
        this.placeholder.setMaxHeight(0.0);
        this.placeholder.prefWidthProperty().bind(collapsible.widthProperty());
    }

    public void collapse() {
        if (this.expanded.get()) {
            int index = this.container.getChildren().indexOf(this.collapsible);
            if (index != -1) {
                this.container.getChildren().set(index, this.placeholder);
            }
            this.expanded.set(false);
        }
    }

    public EventHandler getCollapseEventHandler() {
        return event -> this.collapse();
    }

    public void expand() {
        if (!this.expanded.get()) {
            int index = this.container.getChildren().indexOf(this.placeholder);
            if (index != -1) {
                this.container.getChildren().set(index, this.collapsible);
            }
            this.expanded.set(true);
        }
    }

    public EventHandler getExpandEventHandler() {
        return event -> this.expand();
    }

    public void toggle() {
        if (this.expanded.get()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public boolean getExpanded() {
        return this.expanded.get();
    }
}

