/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.icon;

import com.deutscheboerse.ui.jfx.util.StyleUtil;
import de.jensd.fx.glyphs.GlyphIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class IconView
extends GlyphIcon<FontAwesomeIcon> {
    private static final String TTF_PATH = "/de/jensd/fx/glyphs/fontawesome/fontawesome-webfont.ttf";
    private final StringProperty iconStyleClass;

    public IconView(FontAwesomeIcon icon, String styleClass, Color color, Double rotate) {
        super(FontAwesomeIcon.class);
        this.setFont(new Font("FontAwesome", DEFAULT_ICON_SIZE));
        this.setIcon(icon);
        this.setStyle("-fx-font-family: FontAwesome;");
        this.setRotate(rotate);
        this.setSize("1.2em");
        this.setFill(color);
        this.iconStyleClass = new SimpleStringProperty();
        this.iconStyleClass.addListener((observable2, oldValue, newValue) -> {
            this.getStyleClass().remove(oldValue);
            StyleUtil.addStyleClass(this, newValue);
        });
        this.iconStyleClass.set(styleClass);
    }

    public IconView(FontAwesomeIcon icon) {
        super(FontAwesomeIcon.class);
        this.setFont(new Font("FontAwesome", DEFAULT_ICON_SIZE));
        this.setIcon(icon);
        this.setStyle("-fx-font-family: FontAwesome;");
        this.iconStyleClass = new SimpleStringProperty();
        this.iconStyleClass.addListener((observable2, oldValue, newValue) -> {
            this.getStyleClass().remove(oldValue);
            StyleUtil.addStyleClass(this, newValue);
        });
    }

    public IconView(String iconStyleClass) {
        this(FontAwesomeIcon.ANCHOR);
        this.iconStyleClass.set(iconStyleClass);
    }

    public IconView() {
        this(FontAwesomeIcon.ANCHOR);
    }

    public String getIconStyleClass() {
        return (String)this.iconStyleClass.get();
    }

    public StringProperty iconStyleClassProperty() {
        return this.iconStyleClass;
    }

    public void setIconStyleClass(String iconStyleClass) {
        this.iconStyleClass.set(iconStyleClass);
    }

    @Override
    public FontAwesomeIcon getDefaultGlyph() {
        return FontAwesomeIcon.ANCHOR;
    }

    static {
        Font.loadFont(IconView.class.getResource(TTF_PATH).toExternalForm(), Font.getDefault().getSize());
    }
}

