/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.login;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginModel;
import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginWindow;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.session.DisconnectAction;
import com.deutscheboerse.comxerv.comtrader.entities.session.ProxyType;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.jfx.GuiMessageRecorder;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AboutPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.MainPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.SettingsPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label.LabelKeyAware;
import com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label.LabelKeyAwareTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.NumberTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.UpperCaseAlphaNumericTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.login.AbstractLoginPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.login.AdvancedLoginPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.login.DisconnectActionPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.login.OnThrottlingPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.login.ProxySettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.login.SecurityPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.model.GuiMessageType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.model.SecurityType;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.DirectChildrenByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TabPaneOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.CloseConfirmationService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MainPanelService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MasterProfileService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.manual.ManualService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.FontService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.user.ChangePasswordUiService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.LoginService;
import com.deutscheboerse.comxerv.comtrader.service.LogoutService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.ProfileLoginFailedEvent;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileServiceAuthenticationException;
import com.deutscheboerse.comxerv.comtrader.service.profile.UserProfile;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.deutscheboerse.comxerv.comtrader.util.FileUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.FutureExecutor;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="#this", overrideId="LoginPanel", strategy=DirectChildrenByIdOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="tabPane", overrideId="LoginPanel", strategy=TabPaneOverrideGuiStrategy.class)})
public class LoginPanel
extends FXMLBorderPane
implements MasterLoginWindow {
    private static final Logger LOG = LoggerFactory.getLogger(LoginPanel.class);
    private static final String FONT_BOLD = "-fx-font-weight: bold";
    private static final String FONT_NORMAL = "-fx-font-weight: normal";
    private final Preferences preferences;
    private final ProfileManager profileManager;
    private final BackendConnectionGateway backendConnectionGateway;
    private final LoginService loginService;
    private final FutureExecutor futureExecutor;
    private final LogoutService logoutService;
    private final ConnectionParametersWithFallback connectionParameters;
    private final ChangePasswordUiService changePasswordUiService;
    private final UserAlertService userAlertService;
    private final MasterProfileService masterProfileService;
    private final Stage stage;
    private final CloseConfirmationService closeConfirmationService;
    private final SettingsService settingsService;
    private final MainPanelService mainPanelService;
    private final MasterLoginModel masterLoginModel = this.getAppContext().getService(MasterLoginModel.class);
    private static final String LAST_USERNAME_KEY = "User";
    private static final String LAST_DISCONNECT_ACTION_KEY = "DisconnectAction";
    private static final String CERT_TYPE = "CertType";
    private static final String CERT_PATH = "CertPath";
    private static final String CERT_PASS = "CertPass";
    @FXML
    private Label environment;
    @FXML
    private UpperCaseAlphaNumericTextField singleUsername;
    @FXML
    private PasswordField singlePassword;
    @FXML
    private NumberTextField verificationCode;
    @FXML
    private Button singleLoginButton;
    @FXML
    private Button singleLogoutButton;
    @FXML
    private Button changePasswordButton;
    @FXML
    private ImageView exchangeLogo;
    @FXML
    private Tab securityTab;
    @FXML
    private Tab networkTab;
    @FXML
    private Tab proxyTab;
    @FXML
    private Tab onThrottlingTab;
    @FXML
    private Tab advancedLoginTab;
    @FXML
    private DisconnectActionPane disconnectActionPane;
    @FXML
    private OnThrottlingPane onThrottlingPane;
    @FXML
    private ProxySettingsPane proxyPane;
    @FXML
    private SecurityPane securityPane;
    @FXML
    private AdvancedLoginPane advancedLoginPane;
    @FXML
    private MenuBar menuBar;
    @FXML
    private TabPane tabPane;
    private final BooleanProperty disableLoginControls;
    @FXML
    private MenuItem loadDefaultProfileMenuItem;
    @FXML
    private MenuItem loadLastSavedProfileMenuItem;
    @FXML
    private Label statusLabel;
    @FXML
    private MenuItem openSettingsMenuItem;
    @FXML
    private MenuItem exitMenuItem;
    @FXML
    private MenuItem manualMenuItem;
    @FXML
    private MenuItem recordMessagesMenuItem;

    @Inject
    public LoginPanel(ApplicationContext appContext) {
        super(appContext);
        this.settingsService = this.getAppContext().getService(SettingsService.class);
        this.profileManager = this.getAppContext().getService(ProfileManager.class);
        this.masterProfileService = this.getAppContext().getService(MasterProfileService.class);
        this.backendConnectionGateway = this.getAppContext().getService(BackendConnectionGateway.class);
        this.loginService = this.getAppContext().getService(LoginService.class);
        this.closeConfirmationService = this.getAppContext().getService(CloseConfirmationService.class);
        this.futureExecutor = new FutureExecutor(this.getAppContext().getService(ExecutorService.class, WorkerExecutor.class));
        this.mainPanelService = this.getAppContext().getService(MainPanelService.class);
        this.preferences = Preferences.userNodeForPackage(AbstractLoginPanel.class);
        this.stage = new Stage();
        this.stage.setScene(new Scene(this));
        this.setTitle(null);
        this.stage.centerOnScreen();
        this.stage.setResizable(false);
        this.closeConfirmationService.addWindowCloseConfirmationHandler(this.stage);
        this.getAppContext().getService(WindowService.class).decorateWindow(this.stage);
        this.logoutService = this.getAppContext().getService(LogoutService.class);
        this.connectionParameters = appContext.getService(ConnectionParametersWithFallback.class);
        this.disableLoginControls = new SimpleBooleanProperty(false);
        this.changePasswordUiService = appContext.getService(ChangePasswordUiService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.loadFxml();
    }

    public void initialize() {
        boolean withAdvancedLoginParameters;
        this.getAppContext().getService(EventBus.class).register(this);
        this.exitMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.F4, KeyCombination.ALT_DOWN));
        this.manualMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]));
        this.recordMessagesMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.R, KeyCombination.CONTROL_DOWN, KeyCombination.ALT_DOWN));
        Exchange exchange = this.connectionParameters.getExchange();
        SecurityType securityType = SecurityType.USE_STORED;
        this.connectionParameters.setUsername(this.getWithPrefix(LAST_USERNAME_KEY, exchange, ""));
        this.connectionParameters.setUseOwnCertificate(SecurityType.OVERRIDE == securityType);
        this.connectionParameters.setDisconnectAction(DisconnectAction.valueOf(this.getWithPrefix(LAST_DISCONNECT_ACTION_KEY, exchange, DisconnectAction.NO.name())));
        if (this.connectionParameters.isOwnCertificateEnabled()) {
            securityType = SecurityType.valueOf(this.getWithPrefix(CERT_TYPE, exchange, SecurityType.USE_STORED.name()));
            this.connectionParameters.setUseOwnCertificate(SecurityType.OVERRIDE == securityType);
            this.connectionParameters.setCertificatePath(this.getWithPrefix(CERT_PATH, exchange, ""));
            this.connectionParameters.setCertificatePassword(this.getWithPrefix(CERT_PASS, exchange, ""));
        } else {
            this.tabPane.getTabs().remove(this.securityTab);
        }
        boolean withThrottling = this.getAppContext().getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("withThrottling");
        if (!withThrottling) {
            this.tabPane.getTabs().remove(this.onThrottlingTab);
        }
        if (!(withAdvancedLoginParameters = this.getAppContext().getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("withAdvancedLoginParameters"))) {
            this.tabPane.getTabs().remove(this.advancedLoginTab);
        }
        this.singleUsername.setText(this.connectionParameters.getUsername());
        this.exchangeLogo.setImage(new Image("/images/logo.png"));
        this.environment.setText(this.connectionParameters.getEnvironmentName());
        if (!exchange.supportsLogoutAction()) {
            this.tabPane.getTabs().remove(this.networkTab);
        } else {
            this.networkTab.styleProperty().bind(Bindings.createStringBinding(() -> this.disconnectActionPane.getRadioButtonNoAction().equals(this.disconnectActionPane.getDisconnectActionToggleGroup().getSelectedToggle()) ? FONT_NORMAL : FONT_BOLD, this.disconnectActionPane.getDisconnectActionToggleGroup().selectedToggleProperty()));
        }
        this.proxyTab.styleProperty().bind(Bindings.createStringBinding(() -> this.proxyPane.getProxyChoiceBox().getSelectionModel().getSelectedItem() == ProxyType.NO_PROXY ? FONT_NORMAL : FONT_BOLD, this.proxyPane.getProxyChoiceBox().getSelectionModel().selectedItemProperty()));
        this.proxyPane.loadConnectionParameters(this.connectionParameters);
        this.disconnectActionPane.loadConnectionParameters(this.connectionParameters);
        this.onThrottlingPane.loadConnectionParameters(this.connectionParameters);
        this.securityPane.loadConnectionParameters(this.connectionParameters, this.disableLoginControls, securityType);
        this.advancedLoginPane.loadConnectionParameters(this.connectionParameters);
        this.disconnectActionPane.disableProperty().bind(this.disableLoginControls);
        this.onThrottlingPane.disableProperty().bind(this.disableLoginControls);
        this.proxyPane.disableProperty().bind(this.disableLoginControls);
        this.securityPane.disableProperty().bind(this.disableLoginControls);
        this.advancedLoginPane.disableProperty().bind(this.disableLoginControls);
        this.singleLoginButton.disableProperty().bind(this.disableLoginControls.or(this.singleUsername.textProperty().isEqualTo("")).or(this.singlePassword.textProperty().isEqualTo("")));
        this.singleUsername.disableProperty().bind(this.disableLoginControls);
        this.verificationCode.disableProperty().bind(this.disableLoginControls);
        this.singlePassword.disableProperty().bind(this.disableLoginControls);
        this.singleLogoutButton.disableProperty().bind(this.disableLoginControls.not());
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyCode.ENTER.equals((Object)keyEvent.getCode()) && !this.singleLoginButton.isDisabled()) {
                this.loginButtonAction();
                keyEvent.consume();
            }
        });
        this.openSettingsMenuItem.disableProperty().bind(this.disableLoginControls.not());
        this.loadDefaultProfileMenuItem.disableProperty().bind(this.disableLoginControls.not());
        this.loadLastSavedProfileMenuItem.disableProperty().bind(this.disableLoginControls.not());
        this.setChangePasswordButtonVisibility();
        this.getAppContext().getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
    }

    private void profileLoadSuccess() {
        this.settingsService.loadAllSettings();
        this.mainPanelService.loadSavedMainPanels();
    }

    @Override
    public void showLoginWindow() {
        this.stage.show();
        this.stage.toFront();
    }

    @Override
    public boolean isLoginWindowShowing() {
        return this.stage.isShowing();
    }

    @FXML
    public void recordMessages() {
        this.getAppContext().getService(GuiMessageRecorder.class).activateRecording();
    }

    @FXML
    public void configureLookAndFeel() {
        SettingsPanel settingsPanel = new SettingsPanel(this.getAppContext());
        settingsPanel.showSettingsPanel();
    }

    @FXML
    public void retrieveLogs() {
        FileUtil.openLogFileFolder();
    }

    @FXML
    public void exit() {
        this.closeConfirmationService.applicationExitRequested();
    }

    @FXML
    public void defaultMainPanels() {
        this.masterProfileService.loadDefaultProfile(true);
    }

    @FXML
    public void restoreSavedMainPanels() {
        this.masterProfileService.loadSavedProfile(true);
    }

    @FXML
    public void openAboutDialog() {
        this.getAppContext().getService(AboutPanel.class).showDialog();
    }

    @FXML
    public void openManualDialog() {
        this.getAppContext().getService(ManualService.class).showManual();
    }

    @FXML
    public void loadCustomLogging() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Util.getLabel("commons_customLogging"));
        FileChooser.ExtensionFilter xmlFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_xmlFilesFilter"), "*.xml");
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_allFiles"), "*.*");
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{xmlFilter, allFilter});
        fileChooser.setSelectedExtensionFilter(xmlFilter);
        File logFile = fileChooser.showOpenDialog(new Stage(StageStyle.DECORATED));
        if (logFile != null && logFile.exists()) {
            LOG.info("Setting custom logging: {}", (Object)logFile.getAbsoluteFile());
            FileUtil.loadCustomLogConfig(logFile);
        }
    }

    private void showStatusMessage(String message, GuiMessageType guiMessageType) {
        if (GuiMessageType.SUCCESS_MESSAGE == guiMessageType) {
            LOG.info(message);
        } else {
            LOG.error(message);
        }
        this.statusLabel.setText(message);
        this.statusLabel.setGraphic(new IconView(guiMessageType.getIconStyleClass()));
    }

    private void showConnectingMessage() {
        ProgressIndicator connectingIndicator = new ProgressIndicator(-1.0);
        connectingIndicator.setPrefWidth(FontService.FontSize.NORMAL.getFontSize());
        connectingIndicator.setPrefHeight(FontService.FontSize.NORMAL.getFontSize());
        this.statusLabel.setGraphic(connectingIndicator);
        this.statusLabel.setText(Util.getLabel("singleLogin_connecting"));
    }

    private void showFailedMessage(Throwable throwable) {
        LOG.error("", throwable);
        if (throwable instanceof ExecutionException && throwable.getCause() != null) {
            this.showFailedMessage(throwable.getCause());
        } else if (throwable instanceof LoginException) {
            this.showStatusMessage(throwable.getMessage(), GuiMessageType.ERROR_MESSAGE);
        } else if (throwable instanceof ProfileServiceException) {
            this.showStatusMessage(Util.getLabel("profile_service_error", throwable.getMessage()), GuiMessageType.ERROR_MESSAGE);
        } else if (throwable instanceof ProfileServiceAuthenticationException) {
            this.showStatusMessage(Util.getLabel("remote_profile_Service_auth_error"), GuiMessageType.ERROR_MESSAGE);
        } else {
            this.showStatusMessage(Util.getLabel("unknown_error", throwable.getMessage()), GuiMessageType.ERROR_MESSAGE);
        }
    }

    private String getWithPrefix(String key, Exchange exchange, String defaultValue) {
        String prefix = exchange.getId();
        String value = this.preferences.get(prefix + key, null);
        if (value == null) {
            value = this.preferences.get(key, defaultValue);
        }
        return value;
    }

    @Subscribe
    public void handleLogout(LogoutEvent event) {
        String reloginMessage = event.getReloginMessage();
        this.mainPanelService.closeAllMainPanels();
        if (reloginMessage != null && this.userAlertService.showQuestionDialog(Util.getLabel("commons_forceLogout"), Util.getLabel("connectionFailedNotification"), UserAlertService.Flag.RELOGIN_CLOSE)) {
            LOG.info("User reconnecting");
            this.loginButtonAction();
        } else {
            this.resetSingleLoginForm();
            String message = Util.getLabel("masterLogin_messageLog_disconnect") + this.connectionParameters.getName();
            LOG.info(message);
            this.showStatusMessage(message, GuiMessageType.SUCCESS_MESSAGE);
        }
    }

    @FXML
    public void logoutButtonAction() {
        this.mainPanelService.closeAllMainPanels();
        Session session = this.backendConnectionGateway.getSession();
        if (session != null) {
            this.logoutService.logout();
        }
        this.resetTitle();
    }

    @Override
    public void resetTitle() {
        this.setTitle(null);
    }

    @FXML
    public void loginButtonAction() {
        this.masterLoginModel.setMasterUsername(this.singleUsername.getText());
        this.masterLoginModel.setMasterPassword(this.singlePassword.getText());
        this.disableLoginControls.setValue(true);
        this.showConnectingMessage();
        this.loadMasterProfile();
    }

    @FXML
    public void changePasswordButtonAction() {
        Window parent = this.getAppContext().getService(MainPanelService.class).getFirstMainPanel().map(MainPanel::getStage).orElse(this.getScene().getWindow());
        this.changePasswordUiService.showChangePasswordUi(this.connectionParameters, parent);
    }

    private void resetSingleLoginForm() {
        this.setChangePasswordButtonVisibility();
        this.disableLoginControls.setValue(false);
        this.singlePassword.setText("");
        this.verificationCode.setText("");
        this.connectionParameters.setPassword("");
        this.connectionParameters.setUseOwnCertificate(false);
        this.connectionParameters.setCertificatePath("");
        this.connectionParameters.setCertificatePassword("");
        this.securityPane.reset(this.connectionParameters);
        this.resetTitle();
    }

    private void loadMasterProfile() {
        Future<UserProfile> profileLoading = this.profileManager.loadOrCreateProfile();
        this.futureExecutor.waitForFutureToComplete(profileLoading, this::profileLoadedSuccessfully, this::taskFailed);
    }

    private void profileLoadedSuccessfully(UserProfile userProfile) {
        try {
            this.profileLoadSuccess();
        }
        catch (Exception e) {
            LOG.error("Profile load error. " + String.valueOf(userProfile), e);
            this.userAlertService.showConfirmationDialog(Util.getLabel("commons_error"), Util.getLabel("profile_loading_error_default_will_be_used"), UserAlertService.Flag.ERROR);
            Future<UserProfile> loadDefaultProfileFuture = this.profileManager.loadDefaultProfile();
            this.futureExecutor.waitForFutureToComplete(loadDefaultProfileFuture, this::profileLoadedSuccessfully, this::taskFailed);
            return;
        }
        this.securityPane.setConnectionParametersValues(this.connectionParameters, this.singlePassword.getText().toCharArray());
        this.advancedLoginPane.setConnectionParametersValues(this.connectionParameters);
        this.connectionParameters.setUsername(this.singleUsername.getText());
        this.connectionParameters.setPassword(this.singlePassword.getText());
        this.connectionParameters.setVerificationCode(this.verificationCode.getText());
        this.login();
    }

    private void login() {
        Future<Session> loginFuture = this.loginService.login(this.connectionParameters);
        this.futureExecutor.waitForFutureToComplete(loginFuture, this::successLogin, this::taskFailed);
    }

    private void taskFailed(Throwable throwable) {
        this.getAppContext().getService(EventBus.class).post(new ProfileLoginFailedEvent());
        this.mainPanelService.closeAllMainPanels();
        this.resetSingleLoginForm();
        this.showFailedMessage(throwable);
    }

    private void successLogin(Session session) {
        this.setChangePasswordButtonVisibility();
        String prefix = this.connectionParameters.getExchange().getId();
        this.preferences.put(prefix + LAST_USERNAME_KEY, this.connectionParameters.getUsername());
        this.preferences.put(prefix + LAST_DISCONNECT_ACTION_KEY, this.connectionParameters.getDisconnectAction().name());
        if (this.connectionParameters.isOwnCertificateEnabled()) {
            this.preferences.put(prefix + CERT_TYPE, this.connectionParameters.isUseOwnCertificate() ? SecurityType.OVERRIDE.name() : SecurityType.USE_STORED.name());
            this.preferences.put(prefix + CERT_PATH, this.connectionParameters.getCertificatePath());
            this.preferences.put(prefix + CERT_PASS, this.connectionParameters.getCertificatePassword());
        }
        String message = Util.getLabel("commons_connectedTo", session.getExchange().getName());
        this.showStatusMessage(message, GuiMessageType.SUCCESS_MESSAGE);
        this.setTitle(this.connectionParameters.getUsername());
        this.verificationCode.setText("");
    }

    private void setChangePasswordButtonVisibility() {
        if (this.changePasswordUiService.showChangePasswordButton(this.connectionParameters.getExchange())) {
            this.changePasswordButton.setVisible(true);
            this.changePasswordButton.setText(Util.getLabel("commons_changePassword"));
        } else if (StringUtils.isNotEmpty(this.connectionParameters.getChangePasswordHost())) {
            this.changePasswordButton.setVisible(true);
            this.changePasswordButton.setText(Util.getLabel("commons_forgottenPassword"));
        } else {
            this.changePasswordButton.setVisible(false);
        }
    }

    @Override
    public void reloadLabels() {
        this.restoreNodesLabels(this.getChildrenUnmodifiable());
        this.restoreMenuLabels();
        this.restoreTabPaneLabels();
    }

    private void restoreTabPaneLabels() {
        this.tabPane.getTabs().stream().filter(tab -> tab instanceof LabelKeyAwareTab).map(LabelKeyAwareTab.class::cast).forEach(LabelKeyAwareTab::reloadLabel);
    }

    private void restoreNodesLabels(List<Node> nodes) {
        nodes.forEach(node -> {
            if (node instanceof LabelKeyAware) {
                LabelKeyAware labelKeyAware = (LabelKeyAware)((Object)node);
                labelKeyAware.reloadLabel();
            }
            if (node instanceof Parent) {
                this.restoreNodesLabels(((Parent)node).getChildrenUnmodifiable());
            }
        });
    }

    private void restoreMenuLabels() {
        this.menuBar.getMenus().forEach(this::restoreMenuItemLabel);
    }

    private void restoreMenuItemLabel(MenuItem menuItem) {
        if (menuItem instanceof LabelKeyAware) {
            ((LabelKeyAware)((Object)menuItem)).reloadLabel();
        }
        if (menuItem instanceof Menu) {
            ((Menu)menuItem).getItems().forEach(this::restoreMenuItemLabel);
        }
    }

    private void setTitle(String userName) {
        String version = this.getAppContext().getService(VersionService.class).getComtraderVersion();
        String title = Util.getLabel("application_name") + " " + version;
        if (userName == null || userName.isEmpty()) {
            this.stage.setTitle(title);
        } else {
            this.stage.setTitle(userName + " | " + title);
        }
    }

    public TabPane getTabPane() {
        return this.tabPane;
    }
}

