/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapperWithEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatistics;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatisticsService;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class CollapsibleValueOrderbookWrapper
extends OrderbookValueWrapperWithEntries {
    private final BooleanProperty collapsed;
    private final ObservableValue<Integer> rowLimit;
    private final BooleanProperty needsMore;
    private final BatchUpdateListener entriesUpdateListener;
    private final BatchUpdateListener weakEntriesUpdateListener;
    private final ReadOnlyObjectProperty<OrderbookRemovalCallback> orderbookRemovalCallback;
    private final ObjectProperty<OwnVolumeStatistics> ownVolumeStatistics;

    public CollapsibleValueOrderbookWrapper(Orderbook orderbook, OrderbookRemovalCallback orderbookRemovalCallback, ContractAdditionOrigin origin, ObservableValue<Integer> rowLimit, boolean collapsed, OwnVolumeStatisticsService ownVolumeStatisticsService, Consumer<OrderbookValueWrapper> orderbookChanged) {
        super(origin, orderbookRemovalCallback::removeOrHideOrderbook, orderbookRemovalCallback::updatedItem, orderbookChanged);
        this.orderbookRemovalCallback = new ReadOnlyObjectWrapper<OrderbookRemovalCallback>(orderbookRemovalCallback).getReadOnlyProperty();
        this.rowLimit = rowLimit;
        this.collapsed = new SimpleBooleanProperty(collapsed);
        this.needsMore = new SimpleBooleanProperty(false);
        this.entriesUpdateListener = BatchUpdateAdapter.batchFinishedListener(this::entriesChanged);
        this.weakEntriesUpdateListener = new WeakBatchUpdateListener(this.entriesUpdateListener);
        this.buysProperty().addListener(this::entriesValueChanged);
        this.sellsProperty().addListener(this::entriesValueChanged);
        this.setOrderbook(orderbook);
        this.ownVolumeStatistics = new SimpleObjectProperty<OwnVolumeStatistics>();
        this.ownVolumeStatistics.bind(DependentBinding.get(ownVolumeStatisticsService::forOrderbook, this.orderbookProperty()));
        this.orderbookProperty().addListener(listener -> orderbookRemovalCallback.updatedItem(this.getOrderbook(), Boolean.FALSE));
    }

    private void entriesValueChanged(ObservableValue<? extends ComputedOrderbookEntries> observable2, ComputedOrderbookEntries oldValue, ComputedOrderbookEntries newValue) {
        if (oldValue != null) {
            oldValue.removeListener(this.weakEntriesUpdateListener);
        }
        if (newValue != null) {
            newValue.addListener(this.weakEntriesUpdateListener);
        }
        this.entriesChanged();
    }

    private void entriesChanged() {
        this.needsMore.setValue(this.getBuys() != null && this.getSells() != null && (this.getBuys().size() > 1 || this.getSells().size() > 1));
    }

    public boolean isNeedsMore() {
        return this.needsMore.get();
    }

    public ReadOnlyBooleanProperty needsMoreProperty() {
        return this.needsMore;
    }

    public boolean isCollapsed() {
        return this.collapsed.get();
    }

    public BooleanProperty collapsedProperty() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed.set(collapsed);
    }

    public void toggle() {
        this.setCollapsed(!this.isCollapsed());
    }

    public ObservableValue<Integer> rowLimitProperty() {
        return this.rowLimit;
    }

    public OrderbookRemovalCallback getOrderbookRemovalCallback() {
        return (OrderbookRemovalCallback)this.orderbookRemovalCallback.get();
    }

    public ReadOnlyObjectProperty<OrderbookRemovalCallback> orderbookRemovalCallbackProperty() {
        return this.orderbookRemovalCallback;
    }

    public OwnVolumeStatistics getOwnVolumeStatistics() {
        return (OwnVolumeStatistics)this.ownVolumeStatistics.get();
    }

    public ReadOnlyObjectProperty<OwnVolumeStatistics> ownVolumeStatisticsProperty() {
        return this.ownVolumeStatistics;
    }
}

