/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.comxerv.OrderQuoteNotification;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.BlockOrderEntryHorizontalPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.OrderEntryHorizontalPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.SimpleOrderEntryHorizontalPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.GlobalKeyboardShortcuts;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.BaseOrderEntryPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.ClearButtonMode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.LiftOrderEntryPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.EditEvent;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StageUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OrderPopupImpl
implements OrderPopup {
    private static final Logger LOG = LoggerFactory.getLogger(OrderPopupImpl.class);
    private static final double MIN_WIDTH = 1100.0;
    private static final double MIN_HEIGHT = 140.0;
    private final ApplicationContext appContext;
    private final Stage stage;
    private final StageUtil stageUtil;
    private double xOffset = 0.0;
    private double yOffset = 0.0;

    @Inject
    public OrderPopupImpl(ApplicationContext appContext) {
        this.appContext = appContext;
        this.stage = new Stage();
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.setResizable(false);
        this.stage.addEventFilter(KeyEvent.KEY_PRESSED, appContext.getService(GlobalKeyboardShortcuts.class));
        this.stage.addEventHandler(WindowEvent.WINDOW_HIDDEN, this::onHidden);
        appContext.getService(WindowService.class).decorateWindow(this.stage);
        appContext.getService(EventBus.class).register(this);
        this.stageUtil = appContext.getService(StageUtil.class);
    }

    @Subscribe
    public void handleEditEvent(EditEvent event) {
        if (event.isEditMode()) {
            this.hide();
        }
    }

    @Override
    public void showAcceptOtcOrderPopup(Order order, Node eventTarget) {
        Order acceptOrder = new Order(order);
        acceptOrder.setDirection(order.getDirection() == Direction.BUY ? Direction.SELL : Direction.BUY);
        acceptOrder.setPreArrangedBalancingGroup(order.getBalancingGroup());
        acceptOrder.setBalancingGroup(order.getPreArrangedBalancingGroup());
        acceptOrder.setDeliveryArea(null);
        BaseOrderEntryPanel orderEntryPanel = this.createOrderEntryPanel(order.getContract().getType(), false);
        orderEntryPanel.populateFromOrder(acceptOrder);
        this.show((Parent)orderEntryPanel, eventTarget);
        FxUtil.runLater(orderEntryPanel::focusDeliveryAreaField);
    }

    @Override
    public void showOrderRequestPopup(OrderQuoteNotification orderRequest, Node eventTarget) {
        BaseOrderEntryPanel orderEntryPanel = this.createOrderEntryPanel(orderRequest.getContract().getType(), false);
        orderEntryPanel.populateFromOrderQuote(orderRequest);
        this.show((Parent)orderEntryPanel, eventTarget);
        FxUtil.runLater(orderEntryPanel::focusQuantityField);
    }

    @Override
    public void showExtendedOrderPopup(Order order, boolean basketMode, Node eventTarget) {
        BaseOrderEntryPanel orderEntryPanel = this.createOrderEntryPanel(Optional.ofNullable(order.getContract()).map(Contract::getType).orElse(ContractType.REGULAR), basketMode);
        orderEntryPanel.populateFromOrder(order);
        this.show((Parent)orderEntryPanel, eventTarget);
        FxUtil.runLater(orderEntryPanel::focusQuantityField);
    }

    @Override
    public void showSimpleOrderPopup(Order order, Node eventTarget) {
        SimpleOrderEntryHorizontalPanel orderEntryPanel = new SimpleOrderEntryHorizontalPanel(this.appContext, ClearButtonMode.CLOSE, false);
        orderEntryPanel.populateFromOrder(order);
        this.show((Parent)orderEntryPanel, eventTarget);
        FxUtil.runLater(orderEntryPanel::focusQuantityField);
    }

    @Override
    public void showExtendedOrderPopup(Orderbook orderbook, Node eventTarget) {
        BaseOrderEntryPanel orderEntryPanel = this.createOrderEntryPanel(orderbook.getContract().getType(), false);
        orderEntryPanel.populateFromOrderbook(orderbook);
        this.show((Parent)orderEntryPanel, eventTarget);
        FxUtil.runLater(orderEntryPanel::focusQuantityField);
    }

    private BaseOrderEntryPanel createOrderEntryPanel(ContractType contractType, boolean basketMode) {
        return contractType.isBlock() ? this.createBlockOrderEntryPanel(basketMode) : this.createCanonicalOrderEntryPanel(basketMode);
    }

    private OrderEntryHorizontalPanel createCanonicalOrderEntryPanel(boolean basketMode) {
        OrderEntryHorizontalPanel orderEntryHorizontalPanel = new OrderEntryHorizontalPanel(this.appContext, ClearButtonMode.CLOSE, basketMode);
        orderEntryHorizontalPanel.setId("orderEntryHorizontalPanelPopUp");
        return orderEntryHorizontalPanel;
    }

    private BlockOrderEntryHorizontalPanel createBlockOrderEntryPanel(boolean basketMode) {
        return new BlockOrderEntryHorizontalPanel(this.appContext, ClearButtonMode.CLOSE, basketMode);
    }

    @Override
    public void showLiftOrderPopup(Order order, Node eventTarget) {
        this.show((Parent)new LiftOrderEntryPanel(this.appContext, order), eventTarget);
    }

    @Override
    public void hide() {
        FxUtil.runInFxThread(() -> {
            if (this.stage.isShowing()) {
                LOG.debug("Hiding {}", (Object)this.stage.getScene().getRoot());
                this.stage.hide();
            }
        });
    }

    private void onHidden(WindowEvent event) {
        Optional.ofNullable(this.stage.getScene()).map(Scene::getRoot).filter(Destroyable.class::isInstance).map(Destroyable.class::cast).ifPresent(Destroyable::destroy);
    }

    private void show(Parent content, Node eventTarget) {
        Point2D middleScreenCoordinates = this.stageUtil.getMiddleScreenCoordinates(eventTarget);
        this.show(content, middleScreenCoordinates);
    }

    private void show(Parent content, Point2D middleScreenCoordinates) {
        if (this.stage.getScene() != null) {
            this.hide();
        }
        content.setOnMousePressed(event -> {
            this.xOffset = event.getSceneX();
            this.yOffset = event.getSceneY();
        });
        content.setOnMouseDragged(event -> {
            this.stage.setX(event.getScreenX() - this.xOffset);
            this.stage.setY(event.getScreenY() - this.yOffset);
        });
        FxUtil.runInFxThread(() -> {
            Scene scene = new Scene(content);
            scene.setOnKeyPressed(keyEvent -> {
                if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    this.hide();
                }
            });
            scene.setFill(null);
            this.stage.setScene(scene);
            LOG.debug("Showing {}", (Object)content);
            this.stage.show();
            this.stage.setX(middleScreenCoordinates.getX() - this.stage.getWidth() / 2.0);
            this.stage.setY(middleScreenCoordinates.getY() - this.stage.getHeight() / 2.0);
            this.stage.setMinWidth(1100.0);
            this.stage.setMinHeight(140.0);
            this.stage.toFront();
        });
    }
}

