/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CollapsibleValueOrderbookWrapper;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingColor;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingRecord;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingService;
import com.deutscheboerse.ui.jfx.util.control.table.ComputedHeightTableRow;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class OrderbookTableRow
extends ComputedHeightTableRow<CollapsibleValueOrderbookWrapper> {
    private final AlertingService alertingService;
    private final ChangeListener<AlertingRecord> listener = (obs, oldValidationResponse, newValidationResponse) -> this.updateStyle();

    public OrderbookTableRow(AlertingService alertingService) {
        this.alertingService = alertingService;
        this.itemProperty().addListener((obs, oldItem, newItem) -> {
            if (oldItem != null) {
                oldItem.alertingInfoProperty().removeListener(this.listener);
            }
            if (newItem != null) {
                newItem.alertingInfoProperty().addListener(this.listener);
            }
            this.updateStyle();
        });
    }

    public static Callback<TableView<CollapsibleValueOrderbookWrapper>, TableRow<CollapsibleValueOrderbookWrapper>> asOrderbookRowFactory(AlertingService alertingService) {
        return tableView -> {
            tableView.setFixedCellSize(-1.0);
            return new OrderbookTableRow(alertingService);
        };
    }

    @Override
    protected void updateItem(CollapsibleValueOrderbookWrapper item, boolean empty) {
        super.updateItem(item, empty);
        this.updateStyle();
    }

    private void updateStyle() {
        CollapsibleValueOrderbookWrapper item = (CollapsibleValueOrderbookWrapper)this.getItem();
        if (item == null || this.isEmpty() || !this.isAlertActive(item)) {
            this.setStyleOff();
        } else if (item.getAlertingInfo() != null && item.getAlertingInfo().getAlertingColor() != AlertingColor.DEFAULT) {
            this.setStyleOn(item.getAlertingInfo().getAlertingColor().getColor().toString().substring(2));
        } else {
            this.setStyleOff();
        }
    }

    private boolean isAlertActive(CollapsibleValueOrderbookWrapper item) {
        return item.getOrderbook() != null && item.getAlertingInfo() != null && this.alertingService.isAlertActive(item.getOrderbook().getContract(), item.getOrderbook().getDeliveryArea(), item.getAlertingInfo().getStart(), item.getAlertingInfo().getEnd());
    }

    private void setStyleOn(String color) {
        this.setStyle("-fx-background-color: derive(#" + color + ", -30%) !important;");
    }

    private void setStyleOff() {
        this.setStyle("");
    }
}

