/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.market;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.AbstractMarketOrderWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.ContextMenuOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

@OverrideGuiConfiguration(field="items", overrideId="OwnMarketContextMenu", strategy=ContextMenuOverrideGuiStrategy.class)
public class OwnMarketContextMenu
extends ContextMenu {
    private final OrderSender orderSender;
    private final MenuItem remove = new MenuItem(Util.getLabel("commons_remove"));
    private final Menu deactivate = new Menu(Util.getLabel("commons_Deactivate"));
    private final MenuItem deactivateAsk = new MenuItem(Util.getLabel("commons_ask"));
    private final MenuItem deactivateBid = new MenuItem(Util.getLabel("commons_bid"));
    private final MenuItem deactivateAll = new MenuItem(Util.getLabel("commons_all"));
    private final Menu delete = new Menu(Util.getLabel("commons_cancel"));
    private final MenuItem deleteAsk = new MenuItem(Util.getLabel("commons_ask"));
    private final MenuItem deleteBid = new MenuItem(Util.getLabel("commons_bid"));
    private final MenuItem deleteAll = new MenuItem(Util.getLabel("commons_all"));
    private final AbstractMarketOrderWrapper marketOrderWrapper;

    public static ContextMenu createContextMenu(AbstractMarketOrderWrapper marketOrderWrapper, ApplicationContext appContext) {
        OwnMarketContextMenu contextMenu = new OwnMarketContextMenu(marketOrderWrapper, appContext);
        appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(contextMenu);
        return contextMenu;
    }

    public OwnMarketContextMenu(AbstractMarketOrderWrapper marketOrderWrapper, ApplicationContext appContext) {
        this.marketOrderWrapper = marketOrderWrapper;
        this.orderSender = appContext.getService(OrderSender.class);
        this.createAction();
        this.createStatusBinding();
        this.buildMenu();
    }

    private void createAction() {
        this.remove.setOnAction(event -> this.marketOrderWrapper.getOrderbookRemovalCallback().removeOrderbookItem(this.marketOrderWrapper));
        this.deactivateAsk.setOnAction(event -> this.orderSender.sendOrder(this.getOrderSending(RequestType.DEACTIVATE, this.marketOrderWrapper.getBestOwnSellOrder())));
        this.deactivateBid.setOnAction(event -> this.orderSender.sendOrder(this.getOrderSending(RequestType.DEACTIVATE, this.marketOrderWrapper.getBestOwnBuyOrder())));
        this.deactivateAll.setOnAction(event -> this.orderSender.sendOrder(this.getOrderSending(RequestType.DEACTIVATE, this.marketOrderWrapper.getBestOwnBuyOrder(), this.marketOrderWrapper.getBestOwnSellOrder())));
        this.deleteAsk.setOnAction(event -> this.orderSender.sendOrder(this.getOrderSending(RequestType.DELETE, this.marketOrderWrapper.getBestOwnSellOrder())));
        this.deleteBid.setOnAction(event -> this.orderSender.sendOrder(this.getOrderSending(RequestType.DELETE, this.marketOrderWrapper.getBestOwnBuyOrder())));
        this.deleteAll.setOnAction(event -> this.orderSender.sendOrder(this.getOrderSending(RequestType.DELETE, this.marketOrderWrapper.getBestOwnBuyOrder(), this.marketOrderWrapper.getBestOwnSellOrder())));
    }

    private OrdersToSend getOrderSending(RequestType requestType, Optional<Order> ... orders) {
        return new OrdersToSend(this.getOrders(orders), requestType, ResponseHandler.EMPTY);
    }

    private Set<Order> getOrders(Optional<Order> ... orders) {
        HashSet<Order> orderSet = new HashSet<Order>();
        Stream.of(orders).filter(Optional::isPresent).map(Optional::get).forEach(orderSet::add);
        return orderSet;
    }

    private void createStatusBinding() {
        BooleanBinding ownAskAndBidAreEmpty = Bindings.and(this.marketOrderWrapper.ownAskPrcProperty().isNull(), this.marketOrderWrapper.ownBidPrcProperty().isNull());
        this.deactivate.disableProperty().bind(ownAskAndBidAreEmpty);
        this.delete.disableProperty().bind(ownAskAndBidAreEmpty);
        BooleanBinding ownAskIsEmpty = this.marketOrderWrapper.ownAskPrcProperty().isNull();
        BooleanBinding ownBidIsEmpty = this.marketOrderWrapper.ownBidPrcProperty().isNull();
        this.deactivateAsk.disableProperty().bind(ownAskIsEmpty);
        this.deleteAsk.disableProperty().bind(ownAskIsEmpty);
        this.deactivateBid.disableProperty().bind(ownBidIsEmpty);
        this.deleteBid.disableProperty().bind(ownBidIsEmpty);
        BooleanBinding ownAskOrBidAreNull = Bindings.or(this.marketOrderWrapper.ownAskPrcProperty().isNull(), this.marketOrderWrapper.ownBidPrcProperty().isNull());
        this.deleteAll.disableProperty().bind(ownAskOrBidAreNull);
        this.deactivateAll.disableProperty().bind(ownAskOrBidAreNull);
    }

    private void buildMenu() {
        this.getItems().add(this.remove);
        this.getItems().add(new SeparatorMenuItem());
        this.deactivate.getItems().add(this.deactivateAsk);
        this.deactivate.getItems().add(this.deactivateBid);
        this.deactivate.getItems().add(this.deactivateAll);
        this.getItems().add(this.deactivate);
        this.delete.getItems().add(this.deleteAsk);
        this.delete.getItems().add(this.deleteBid);
        this.delete.getItems().add(this.deleteAll);
        this.getItems().add(this.delete);
    }
}

