/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.order;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.order.AbstractOrderTooltip;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Singleton;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Singleton
public class OwnOrderRowTooltip
extends AbstractOrderTooltip {
    private final DateTimeFormatter dateFormat = DateTimeFormat.forPattern(Util.getLabel("commons_datePatternSec"));

    @Override
    protected String getValidOrderTooltipText(Order order) {
        LongDisplayValue peakPriceDelta;
        StringBuilder sb = new StringBuilder();
        sb.append(Util.getLabel("commons_quantityShort")).append(": ").append(order.getRemainingQuantity()).append(System.lineSeparator());
        LongDisplayValue peakQuantity = order.getPeakQuantity();
        if (peakQuantity != null) {
            sb.append(Util.getLabel("commons_peakQuantityShort")).append(": ").append(peakQuantity).append(System.lineSeparator());
        }
        if ((peakPriceDelta = order.getPeakPriceDelta()) != null) {
            sb.append(Util.getLabel("commons_peakPriceDeltaShort")).append(": ").append(peakPriceDelta).append(System.lineSeparator());
        }
        sb.append(Util.getLabel("commons_priceShort")).append(": ").append(order.getLimitPrice()).append(System.lineSeparator());
        sb.append(Util.getLabel("commons_orderType")).append(": ").append(order.getOrderType().getDisplayName()).append(System.lineSeparator());
        if (order.getExecutionRestriction() != null) {
            sb.append(Util.getLabel("commons_executionRestrictionShort")).append(": ").append(order.getExecutionRestriction().getDisplayName()).append(System.lineSeparator());
        }
        sb.append(Util.getLabel("commons_timestamp")).append(": ").append(this.dateFormat.print(order.getTimeStamp())).append(System.lineSeparator());
        OpenOrClose openCloseIndicator = order.getOpenOrClose();
        if (openCloseIndicator != null) {
            sb.append(Util.getLabel("commons_openCloseShort")).append(": ").append(openCloseIndicator).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

