/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.property.binding.IsTomorrowContractBinding;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColorInvalidationListener;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class ContractCellFactory<T>
implements Callback<TableColumn<T, Contract>, TableCell<T, Contract>> {
    private Pos alignment;

    @Override
    public TableCell<T, Contract> call(TableColumn<T, Contract> orderbookItemStringTableColumn) {
        ContractTableCell orderbookTextCell = new ContractTableCell(this.alignment);
        ColorInvalidationListener.registerForColoredTableColumn(orderbookItemStringTableColumn, orderbookTextCell);
        return orderbookTextCell;
    }

    public Pos getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Pos alignment) {
        this.alignment = alignment;
    }

    protected static class ContractTableCell<T>
    extends TableCell<T, Contract> {
        private final BooleanProperty tomorrowContract = new SimpleBooleanProperty(false);
        private static final String CSS_TOMORROW_CONTRACT_CLASS = "tomorrowContract";

        public ContractTableCell(Pos alignment) {
            this.tomorrowContract.addListener((observable2, oldValue, newValue) -> StyleUtil.addStyleClass(this, CSS_TOMORROW_CONTRACT_CLASS, newValue));
            if (alignment != null) {
                super.setAlignment(alignment);
            }
        }

        @Override
        protected void updateItem(Contract item, boolean empty) {
            super.updateItem(item, empty);
            this.tomorrowContract.unbind();
            this.textProperty().unbind();
            this.setText(null);
            if (!empty && item != null) {
                this.tomorrowContract.bind(new IsTomorrowContractBinding(item, item.getExchange().getSystemInfo()));
                this.textProperty().bind(item.nameProperty());
            }
        }
    }
}

