/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.event.DeselectionEventHandler;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.apache.commons.collections4.CollectionUtils;

public abstract class TradeRowFactory<T extends Trade>
implements Callback<TableView<T>, TableRow<T>> {
    private final ApplicationContext appContext = FXMLLoaderWithContext.getAppContext();

    protected TradeRowFactory() {
    }

    @Override
    public TableRow<T> call(TableView<T> tableView) {
        TradeTableRow tradeTableRow = new TradeTableRow(this.appContext);
        tradeTableRow.updateTableView(tableView);
        return tradeTableRow;
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public abstract ContextMenu getTradeContextMenu(List<T> var1, ApplicationContext var2);

    private final class TradeTableRow
    extends TableRow<T> {
        private final InvalidationListener userChangedListener;
        private final UserService userService;
        private final ObservableValue<User> userObservable;

        public TradeTableRow(ApplicationContext appContext) {
            this.userService = appContext.getService(UserService.class);
            this.userChangedListener = observable2 -> this.setStyleForCurrentUser();
            this.userObservable = this.userService.currentUserProperty();
            this.userObservable.addListener(new WeakInvalidationListener(this.userChangedListener));
            this.setOnContextMenuRequested(contextMenuEvent -> {
                ObservableList selectedTrades = this.getTableView().getSelectionModel().getSelectedItems();
                if (CollectionUtils.isNotEmpty(selectedTrades)) {
                    ContextMenu contextMenu = TradeRowFactory.this.getTradeContextMenu(selectedTrades, appContext);
                    this.setContextMenu(contextMenu);
                    contextMenu.show((Node)contextMenuEvent.getTarget(), contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                }
            });
            this.itemProperty().addListener((observableValue, order, newOrder) -> this.setStyleForCurrentUser());
            this.addEventFilter(MouseEvent.MOUSE_PRESSED, new DeselectionEventHandler(this));
        }

        private boolean isCurrentUser(Trade.OrderInfo orderInfo) {
            if (orderInfo != null) {
                User user = (User)this.userService.currentUserProperty().get();
                return user != null && user.getUserCode().equals(orderInfo.getTraderUserCode()) && ((String)user.getMember().getId()).equals(orderInfo.getMemberCode());
            }
            return false;
        }

        private void setStyleForCurrentUser() {
            Trade trade = (Trade)this.getItem();
            if (trade instanceof FullTrade) {
                FullTrade fullTrade = (FullTrade)trade;
                boolean isOwnSellFullTrade = this.isCurrentUser(fullTrade.getSellOrder());
                boolean isOwnBuyFullTrade = this.isCurrentUser(fullTrade.getBuyOrder());
                if (isOwnSellFullTrade) {
                    this.getStyleClass().remove("nonCurrentSellUser");
                    StyleUtil.addStyleClass(this, "currentSellUser");
                } else {
                    this.getStyleClass().remove("currentSellUser");
                    StyleUtil.addStyleClass(this, "nonCurrentSellUser");
                }
                if (isOwnBuyFullTrade) {
                    this.getStyleClass().remove("nonCurrentBuyUser");
                    StyleUtil.addStyleClass(this, "currentBuyUser");
                } else {
                    this.getStyleClass().remove("currentBuyUser");
                    StyleUtil.addStyleClass(this, "nonCurrentBuyUser");
                }
            } else if (trade instanceof HalfTrade) {
                HalfTrade halfTrade = (HalfTrade)trade;
                boolean isOwnHalfTrade = this.isCurrentUser(halfTrade.getOrder());
                if (isOwnHalfTrade) {
                    this.getStyleClass().remove("nonCurrentUser");
                    StyleUtil.addStyleClass(this, "currentUser");
                } else {
                    this.getStyleClass().remove("currentUser");
                    StyleUtil.addStyleClass(this, "nonCurrentUser");
                }
            } else {
                this.getStyleClass().remove("nonCurrentSellUser");
                this.getStyleClass().remove("currentSellUser");
                this.getStyleClass().remove("nonCurrentBuyUser");
                this.getStyleClass().remove("currentBuyUser");
                this.getStyleClass().remove("nonCurrentUser");
                this.getStyleClass().remove("currentUser");
            }
        }
    }
}

