/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ContextMenuIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.ContextMenuOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.List;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

@OverrideGuiConfiguration(field="items", overrideId="TradeContextMenu", strategy=ContextMenuOverrideGuiStrategy.class)
public class TradeContextMenu
extends ContextMenu {
    public static ContextMenu createContextMenu(List<HalfTrade> trades, ResponseHandler responseHandler, ApplicationContext appContext) {
        TradeContextMenu contextMenu = new TradeContextMenu(trades, appContext.getService(TradeService.class), responseHandler);
        appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(contextMenu);
        return contextMenu;
    }

    protected TradeContextMenu(List<HalfTrade> trades, TradeService tradeService, ResponseHandler responseHandler) {
        if (tradeService.isTradeRecallPossible(trades)) {
            MenuItem recall = new MenuItem(Util.getLabel("commons_recall"));
            recall.setId("recallTradeButton");
            recall.setGraphic(new IconView(ContextMenuIcon.RECALL.getIconStyleClass()));
            recall.setOnAction(event -> tradeService.recallTrades(trades, responseHandler));
            this.getItems().add(recall);
        }
    }
}

