/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.event.ReactOnButtonFocusKeyListener;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ImageFactory;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeProcessingUserInterface;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.control.AutoScaleImageView;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class TradePopupPanel
extends FXMLBorderPane {
    private final Consumer<TradeState> selectedUserAction;
    @FXML
    private Label tradeIdLabel;
    @FXML
    private Label contractLabel;
    @FXML
    private Label qtyLabel;
    @FXML
    private Label prcLabel;
    @FXML
    private Label tradingTimeLabel;
    @FXML
    private Label buyMemberLabel;
    @FXML
    private Label buyTraderLabel;
    @FXML
    private Label buyBalancingLabel;
    @FXML
    private Label buyDeliveryAreaLabel;
    @FXML
    private Label sellMemberLabel;
    @FXML
    private Label sellTraderLabel;
    @FXML
    private Label sellBalancingLabel;
    @FXML
    private Label sellDeliveryAreaLabel;
    @FXML
    private Label questionLabel;
    @FXML
    private HBox buttonGroupHBox;
    private final Button yesButton = new ButtonWithIcon(Util.getLabel("commons_yes"), "button-accept");
    private final Button noButton = new ButtonWithIcon(Util.getLabel("commons_no"), "button-reject");
    private final Button acceptButton = new ButtonWithIcon(Util.getLabel("commons_acceptLabel"), "button-accept");
    private final Button rejectButton = new ButtonWithIcon(Util.getLabel("commons_reject"), "button-reject");
    private final Button cancelButton = new ButtonWithIcon(Util.getLabel("commons_cancel"), "button-close");

    public TradePopupPanel(ApplicationContext appContext, FullTrade trade, Consumer<TradeState> selectedUserAction, TradeProcessingUserInterface.Mode tradePopupMode) {
        super(appContext);
        Trade.OrderInfo sellOrder;
        this.selectedUserAction = selectedUserAction;
        this.loadFxml();
        if (trade.getId() != null) {
            this.tradeIdLabel.setText(((Long)trade.getId()).toString());
        }
        this.contractLabel.setText(trade.getContract().getName());
        this.qtyLabel.setText(trade.getQuantity().toString());
        this.prcLabel.setText(trade.getPrice().toString());
        LocalService localService = appContext.getService(LocalService.class);
        this.tradingTimeLabel.setText(localService.formatDateTime(trade.getTimeStamp()));
        this.tradingTimeLabel.textProperty().setValue(localService.formatDateTime(trade.getTimeStamp()));
        Trade.OrderInfo buyOrder = trade.getBuyOrder();
        if (buyOrder != null) {
            Optional<User> buyUser = Optional.ofNullable(buyOrder.getUser());
            this.buyMemberLabel.setText(buyUser.map(User::getMember).map(Member::getDisplayName).orElse(buyOrder.getMemberCode()));
            this.buyTraderLabel.setText(buyUser.map(User::getDisplayName).orElse(buyOrder.getTraderUserCode()));
            if (buyOrder.getDeliveryArea() != null) {
                this.buyDeliveryAreaLabel.setText(buyOrder.getDeliveryArea().getName());
                AutoScaleImageView buyImageView = new AutoScaleImageView(this.buyDeliveryAreaLabel);
                buyImageView.setImage(ImageFactory.getImage(buyOrder.getDeliveryArea(), "/com/deutscheboerse/comxerv/comtrader/flags/64x64/00_default.png"));
                this.buyDeliveryAreaLabel.setGraphic(buyImageView);
            }
            if (buyOrder.getBalancingGroup() != null) {
                this.buyBalancingLabel.setText(buyOrder.getBalancingGroup().getName());
            }
        }
        if ((sellOrder = trade.getSellOrder()) != null) {
            Optional<User> sellUser = Optional.ofNullable(sellOrder.getUser());
            this.sellMemberLabel.setText(sellUser.map(User::getMember).map(Member::getDisplayName).orElse(sellOrder.getMemberCode()));
            this.sellTraderLabel.setText(sellUser.map(User::getDisplayName).orElse(sellOrder.getTraderUserCode()));
            if (sellOrder.getDeliveryArea() != null) {
                this.sellDeliveryAreaLabel.setText(sellOrder.getDeliveryArea().getName());
                AutoScaleImageView sellImageView = new AutoScaleImageView(this.buyDeliveryAreaLabel);
                sellImageView.setImage(ImageFactory.getImage(sellOrder.getDeliveryArea(), "/com/deutscheboerse/comxerv/comtrader/flags/64x64/00_default.png"));
                this.sellDeliveryAreaLabel.setGraphic(sellImageView);
            }
            if (sellOrder.getBalancingGroup() != null) {
                this.sellBalancingLabel.setText(sellOrder.getBalancingGroup().getName());
            }
        }
        this.yesButton.setOnAction(this.createActionEvent(TradeState.CANCELLED));
        this.noButton.setOnAction(this.createActionEvent(null));
        if (trade.getTradeState() == TradeState.CANCEL_REQUESTED) {
            this.acceptButton.setOnAction(this.createActionEvent(TradeState.CANCELLED));
            this.rejectButton.setOnAction(this.createActionEvent(TradeState.CANCEL_REJECTED));
        } else {
            this.acceptButton.setOnAction(this.createActionEvent(TradeState.RECALL_GRANTED));
            this.rejectButton.setOnAction(this.createActionEvent(TradeState.RECALL_REJECTED));
        }
        this.cancelButton.setOnAction(this.createActionEvent(null));
        this.setOnKeyPressed(new ReactOnButtonFocusKeyListener());
        if (TradeProcessingUserInterface.Mode.CANCEL == tradePopupMode || TradeProcessingUserInterface.Mode.CREATE == tradePopupMode) {
            this.buttonGroupHBox.getChildren().addAll((Node[])new Node[]{this.yesButton, this.noButton});
            this.noButton.setCancelButton(true);
        } else {
            this.buttonGroupHBox.getChildren().addAll((Node[])new Node[]{this.acceptButton, this.rejectButton, this.cancelButton});
            this.cancelButton.setCancelButton(true);
        }
        if (TradeProcessingUserInterface.Mode.CREATE == tradePopupMode) {
            this.questionLabel.setText(Util.getLabel("tradeCancellationConfirmationPanel_prearrangedTradeQuestion"));
        } else {
            String questionParameter = TradeProcessingUserInterface.Mode.CANCEL == tradePopupMode || TradeState.CANCEL_REQUESTED.equals(trade.getTradeState()) ? Util.getLabel("commons_cancel") : Util.getLabel("commons_recall");
            this.questionLabel.setText(Util.getLabel("tradeCancellationConfirmationPanel_tradeQuestion", questionParameter));
        }
    }

    private EventHandler<ActionEvent> createActionEvent(TradeState tradeState) {
        return event -> this.selectedUserAction.accept(tradeState);
    }
}

