/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides;

import com.deutscheboerse.comxerv.comtrader.jfx.overrides.AbstractOverrideConfigurationsExecutorImpl;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.exception.ApplyingOverridesException;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AbstractOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideGuiConfigurationsExecutorImpl
extends AbstractOverrideConfigurationsExecutorImpl
implements OverrideGuiConfigurationsExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OverrideGuiConfigurationsExecutorImpl.class);
    private final Set<Object> registeredTargets = Collections.newSetFromMap(new WeakHashMap());

    @Inject
    public OverrideGuiConfigurationsExecutorImpl(EventBus eventBus, ApplicationConfigurationService applicationConfigurationService) {
        super(eventBus, applicationConfigurationService);
    }

    @Override
    public void registerAndApply(Object ... targets) {
        Stream.of(targets).forEach(this::registerAndApply);
    }

    private void registerAndApply(Object target) {
        this.registeredTargets.add(target);
        this.apply(target);
    }

    @Override
    public void handleLoadingFinishedEvent(LoadingFinishedEvent loadingFinishedEvent) {
        super.handleLoadingFinishedEvent(loadingFinishedEvent);
        this.apply();
    }

    private void apply() {
        this.registeredTargets.stream().filter(Objects::nonNull).forEach(this::apply);
    }

    private void apply(Object target) {
        OverrideGuiConfiguration[] configs;
        for (OverrideGuiConfiguration config : configs = (OverrideGuiConfiguration[])target.getClass().getAnnotationsByType(OverrideGuiConfiguration.class)) {
            this.applyWithConfig(target, config);
        }
    }

    protected void applyWithConfig(Object target, OverrideGuiConfiguration config) {
        try {
            Object fieldValue = this.getTargetFieldValue(target, config.field());
            AbstractOverrideGuiStrategy strategy = config.strategy().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            strategy.apply(fieldValue, config.overrideId(), this.overrides);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error("Error during applying strategy for {}", (Object)target.getClass(), (Object)e);
            throw new ApplyingOverridesException(e);
        }
    }

    private Object getTargetFieldValue(Object target, String fieldName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if ("#this".equals(fieldName)) {
            return target;
        }
        return MethodUtils.invokeMethod(target, this.convertToGetMethod(fieldName));
    }

    private String convertToGetMethod(String fieldName) {
        return StringUtils.isBlank(fieldName) ? fieldName : "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }
}

