/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui;

import com.deutscheboerse.comxerv.comtrader.jfx.overrides.functional.FieldsToOverrideResolver;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AbstractOverrideGuiStrategy;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import org.json.simple.JSONObject;

public class MenuBarOverrideGuiStrategy
extends AbstractOverrideGuiStrategy<MenuBar, MenuItem> {
    public MenuBarOverrideGuiStrategy() {
        super(new RecursiveMenuItemResolver(), MenuItem::getId);
    }

    @Override
    public void apply(MenuBar fieldValue, String overrideId, JSONObject json) {
        if (fieldValue != null) {
            Map<String, List<JSONObject>> overrides = this.groupByKey(json, overrideId);
            fieldValue.getMenus().removeIf(menu -> this.getOverridesForSubfield(menu, overrides).stream().anyMatch(this::isRemoveOp));
            fieldValue.getMenus().forEach(menu -> this.applyRecursively((Menu)menu, overrides));
        }
    }

    private void applyRecursively(Menu menu, Map<String, List<JSONObject>> overrides) {
        menu.getItems().removeIf(menuItem -> this.getOverridesForSubfield(menuItem, overrides).stream().anyMatch(this::isRemoveOp));
        menu.getItems().stream().filter(Menu.class::isInstance).map(Menu.class::cast).forEach(subMenu -> this.applyRecursively((Menu)subMenu, overrides));
    }

    protected static class RecursiveMenuItemResolver
    implements FieldsToOverrideResolver<MenuBar, MenuItem> {
        protected RecursiveMenuItemResolver() {
        }

        @Override
        public List<MenuItem> resolve(MenuBar menuBar) {
            return menuBar.getMenus().stream().flatMap(this::getItemsRecursive).toList();
        }

        private Stream<MenuItem> getItemsRecursive(MenuItem menuItem) {
            if (menuItem instanceof Menu) {
                return Stream.concat(Stream.of(menuItem), ((Menu)menuItem).getItems().stream().flatMap(this::getItemsRecursive));
            }
            return Stream.of(menuItem);
        }
    }
}

