/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationUI;
import com.deutscheboerse.comxerv.comtrader.jfx.service.CloseConfirmationService;
import com.deutscheboerse.comxerv.comtrader.service.LogoutService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.util.LabelEvaluator;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

@Singleton
public class CloseConfirmationServiceImpl
implements CloseConfirmationService {
    private static final LabelEvaluator EXIT_CONFIRMATION_HEADER = LabelEvaluator.of("commons_confirmation");
    private static final LabelEvaluator EXIT_CONFIRMATION_QUESTION = LabelEvaluator.of("exitConfirmation_question");
    private final UserAlertService userAlertService;
    private final LogoutService logoutService;
    private final ApplicationContext applicationContext;
    private final Set<Window> windows;

    @Inject
    public CloseConfirmationServiceImpl(ApplicationContext applicationContext) {
        this.userAlertService = applicationContext.getService(UserAlertService.class);
        this.logoutService = applicationContext.getService(LogoutService.class);
        this.applicationContext = applicationContext;
        this.windows = new HashSet<Window>();
    }

    @Override
    public void addWindowCloseConfirmationHandler(Window window) {
        window.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, this::windowCloseRequest);
        window.addEventHandler(WindowEvent.WINDOW_SHOWN, event -> this.windows.add((Window)event.getSource()));
        this.windows.add(window);
    }

    @Override
    public void unregister(Window window) {
        this.windows.remove(window);
    }

    private void windowCloseRequest(WindowEvent event) {
        boolean lastWindow;
        boolean bl = lastWindow = this.windows.stream().filter(Window::isShowing).count() == 1L;
        if (lastWindow) {
            boolean exitConfirmed = this.confirmExit();
            if (exitConfirmed) {
                this.logoutAllAndExit();
            } else {
                event.consume();
            }
        }
    }

    private boolean confirmExit() {
        return this.userAlertService.showQuestionDialog(EXIT_CONFIRMATION_HEADER.eval(new Object[0]), EXIT_CONFIRMATION_QUESTION.eval(new Object[0]), UserAlertService.Flag.OK_CANCEL);
    }

    @Override
    public void applicationExitRequested() {
        boolean exitConfirmed = this.confirmExit();
        if (exitConfirmed) {
            this.logoutAllAndExit();
        }
    }

    private void logoutAllAndExit() {
        this.logoutService.logout(this.applicationContext.getService(ApplicationUI.class)::exit);
    }
}

