/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginWindow;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.MainPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.state.PanelWithBottomToolbarState;
import com.deutscheboerse.comxerv.comtrader.jfx.service.CloseConfirmationService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.GuiStateService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MagnifiedOrderbookPopupService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MainPanelService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.StageWithSuffix;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowStateStorage;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoginEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.SaveConfigurationEvent;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MainPanelServiceImpl
implements MainPanelService {
    private static final double WIDTH = 960.0;
    private static final double HEIGHT = 600.0;
    private static final Logger LOG = LoggerFactory.getLogger(MainPanelServiceImpl.class);
    private static final SettingsService.Settings<Map<String, PanelWithBottomToolbarState>> MAIN_PANEL_SETTINGS = new SettingsService.Settings(MainPanelService.class.getName(), new HashMap());
    private final Set<MainPanel> mainPanelSet = new HashSet<MainPanel>();
    private final ApplicationContext appContext;
    private final WindowStateStorage windowStateStorage;
    private final MessagePublisher messagePublisher;
    private final EventBus eventBus;
    private final GuiStateService guiStateService;
    private final SettingsService settingsService;
    private final CloseConfirmationService closeConfirmationService;

    @Inject
    public MainPanelServiceImpl(ApplicationContext appContext) {
        this.appContext = appContext;
        this.guiStateService = appContext.getService(GuiStateService.class);
        this.windowStateStorage = new WindowStateStorage(appContext);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.settingsService = appContext.getService(SettingsService.class);
        this.closeConfirmationService = appContext.getService(CloseConfirmationService.class);
        this.eventBus.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSavedMainPanels() {
        this.closeAllMainPanels();
        try {
            this.guiStateService.setSuspendEditMode(true);
            Map<String, PanelWithBottomToolbarState> mainPanelStateMap = this.settingsService.loadSettings(MAIN_PANEL_SETTINGS);
            for (String suffix : this.windowStateStorage.getSuffixSet()) {
                LOG.info("Load window with suffix: {}", (Object)suffix);
                MainPanel mainPanel = this.createMainPanel(suffix);
                mainPanel.restoreState(mainPanelStateMap.get(suffix));
                mainPanel.restoreComponents();
            }
        }
        finally {
            this.guiStateService.setSuspendEditMode(false);
        }
    }

    @Override
    public void showMainPanels() {
        this.mainPanelSet.forEach(panel -> panel.getStage().show());
    }

    @Override
    public MainPanel getMainPanelBySuffix(String suffix) {
        return this.mainPanelSet.stream().filter(mainPanel -> mainPanel.getSuffix().equals(suffix)).findFirst().orElse(null);
    }

    @Override
    public Optional<MainPanel> getFirstMainPanel() {
        return this.mainPanelSet.stream().findFirst();
    }

    @Override
    public MainPanel createMainPanel() {
        String suffix = this.getFreeSuffix();
        MainPanel newMainPanel = this.createMainPanel(suffix);
        newMainPanel.getStage().show();
        LOG.info("Created new dialog with suffix: {}", (Object)suffix);
        return newMainPanel;
    }

    public String getFreeSuffix() {
        Set suffixSet = this.mainPanelSet.stream().map(MainPanel::getSuffix).collect(Collectors.toSet());
        int i = 0;
        String suffix;
        while (suffixSet.contains(suffix = Integer.toString(i))) {
            ++i;
        }
        return suffix;
    }

    @Override
    public void createMainPanelAndSetToEdit() {
        this.guiStateService.setSuspendEditMode(true);
        MainPanel newMainPanel = this.createMainPanel();
        ContentTab firstTab = new ContentTab(this.appContext);
        newMainPanel.getTabPanel().getTabs().add(firstTab);
        newMainPanel.getTabPanel().getSelectionModel().selectFirst();
        newMainPanel.getTabPanel().addPlusTab(false);
        newMainPanel.requestLayout();
        this.guiStateService.setSuspendEditMode(false);
        firstTab.setText(Util.getLabel("commons_newTab"));
        firstTab.editName();
        this.guiStateService.startEditMode();
    }

    private MainPanel createMainPanel(String suffix) {
        StageWithSuffix stageWithSuffix = this.createNewStageWithSuffix(suffix);
        MainPanel childMainPanel = new MainPanel(this.appContext, stageWithSuffix);
        Scene scene = new Scene(childMainPanel, 960.0, 600.0);
        stageWithSuffix.getStage().setScene(scene);
        this.mainPanelSet.add(childMainPanel);
        return childMainPanel;
    }

    private StageWithSuffix createNewStageWithSuffix(String suffix) {
        StageWithSuffix stageWithSuffix = new StageWithSuffix(suffix, new Stage());
        Stage stage = stageWithSuffix.getStage();
        String version = this.appContext.getService(VersionService.class).getComtraderVersion();
        stage.setTitle(Util.getLabel("application_name") + " " + version);
        stage.setMinWidth(960.0);
        stage.setMinHeight(600.0);
        stage.addEventHandler(WindowEvent.WINDOW_HIDDEN, event -> this.handleStageClosedEvent(suffix));
        this.appContext.getService(WindowService.class).decorateWindow(stage);
        this.closeConfirmationService.addWindowCloseConfirmationHandler(stage);
        return stageWithSuffix;
    }

    private void handleStageClosedEvent(String suffix) {
        MainPanel mainPanel = this.getMainPanelBySuffix(suffix);
        if (mainPanel != null) {
            this.mainPanelSet.remove(mainPanel);
            this.destroyMainPanel(mainPanel);
        } else {
            LOG.error("suffix not found: {}", (Object)suffix);
        }
    }

    @Subscribe
    public void handleSaveConfiguration(SaveConfigurationEvent saveConfigurationEvent) {
        if (!this.mainPanelSet.isEmpty()) {
            this.windowStateStorage.saveStageStates(this.mainPanelSet.stream().map(MainPanel::getSuffixStage).collect(Collectors.toSet()));
            Map<String, PanelWithBottomToolbarState> mainPanelStateMap = this.mainPanelSet.stream().collect(Collectors.toMap(MainPanel::getSuffix, MainPanel::getGeneralState));
            this.mainPanelSet.forEach(MainPanel::storeStateInWindowStateStorage);
            this.settingsService.storeSettings(MAIN_PANEL_SETTINGS, mainPanelStateMap);
        }
    }

    @Subscribe
    public void handleLogin(LoginEvent event) {
        this.showMainPanels();
    }

    @Subscribe
    public void handleLoadingFinishedEvent(LoadingFinishedEvent event) {
        this.resetMainPanelMinSize();
    }

    @Override
    public void resetMainPanelMinSize() {
        this.mainPanelSet.forEach(panel -> panel.setMinSize(-1.0, -1.0));
    }

    @Subscribe
    public void handleLogout(LogoutEvent event) {
        this.closeAllMainPanels();
        this.appContext.getService(MasterLoginWindow.class).showLoginWindow();
    }

    @Override
    public void requestCompleteUiRefresh() {
        this.appContext.getService(ProfileManager.class).reloadUiWithoutSavingProfile(this::completeUiRefresh);
    }

    private void completeUiRefresh() {
        for (MainPanel mainPanel : this.mainPanelSet) {
            mainPanel.restoreComponents();
        }
        this.appContext.getService(MagnifiedOrderbookPopupService.class).refreshPanel();
    }

    @Override
    public void exit() {
        Platform.exit();
    }

    @Override
    public void closeAllMainPanels() {
        this.appContext.getService(OrderPopup.class).hide();
        HashSet<MainPanel> mainPanels = new HashSet<MainPanel>(this.mainPanelSet);
        CountDownLatch allPanelsClosed = new CountDownLatch(mainPanels.size());
        for (MainPanel mainPanel : mainPanels) {
            FxUtil.runInFxThread(() -> {
                this.destroyMainPanel(mainPanel);
                this.mainPanelSet.remove(mainPanel);
                allPanelsClosed.countDown();
            });
        }
        try {
            boolean countedDown = allPanelsClosed.await(5L, TimeUnit.SECONDS);
            if (!countedDown) {
                LOG.error(Util.getLabel("mainPanelService_error"));
                this.messagePublisher.publishMessage(Util.getLabel("mainPanelService_error"), MessageSeverity.ERROR);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interupted", e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CountDownLatch prepareAllMainPanelsForSaveConfiguration() {
        CountDownLatch finishedAllPanels = new CountDownLatch(this.mainPanelSet.size());
        this.mainPanelSet.forEach(mainPanel -> mainPanel.forceDisplayAllTabs(finishedAllPanels));
        return finishedAllPanels;
    }

    private void destroyMainPanel(MainPanel mainPanel) {
        mainPanel.destroy();
        this.eventBus.unregister(mainPanel);
        this.closeConfirmationService.unregister(mainPanel.getStage());
        mainPanel.getStage().close();
        LOG.info("Removed dialog with suffix: {}", (Object)mainPanel.getSuffix());
    }
}

