/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.version;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionMismatchWarningDialog
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(VersionMismatchWarningDialog.class);
    private static final int DEFAULT_TIMEOUT = 10;
    private Stage stage;
    private final StyleService styleService;
    private final ApplicationConfigurationService configService;
    private final ScheduledExecutorService executor;
    @FXML
    private Button okButton;
    @FXML
    private Hyperlink hyperlink;
    private final AtomicInteger counter;
    private volatile ScheduledFuture<?> countDownFuture;

    public VersionMismatchWarningDialog(ApplicationContext appContext) {
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.styleService = appContext.getService(StyleService.class);
        this.configService = appContext.getService(ApplicationConfigurationService.class);
        this.executor = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.counter = new AtomicInteger(this.getPopupTimeout());
        String downloadPage = appContext.getService(ApplicationConfigurationService.class).getApplicationProperty("customerPortalUrl");
        this.hyperlink.setText(downloadPage);
    }

    private Integer getPopupTimeout() {
        try {
            return this.configService.getIntegerApplicationProperty("version.mismatch.popup.timeout", 10);
        }
        catch (NumberFormatException e) {
            LOG.error("Error when parsing version.mismatch.popup.timeout, using the default. {}", (Object)e.getMessage());
            return 10;
        }
    }

    public void initialize() {
        this.hyperlink.setOnAction(event -> this.executor.execute(() -> {
            try {
                Desktop.getDesktop().browse(new URI(this.hyperlink.getText()));
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Enable to open system browser", e);
            }
        }));
        LOG.info("Version mismatch dialog initialized.");
    }

    @FXML
    public void okPressed() {
        this.close();
    }

    public void startCounter() {
        this.startCounter(TimeUnit.SECONDS);
    }

    void startCounter(TimeUnit timeUnit) {
        this.printOKButtonText();
        this.countDownFuture = this.executor.scheduleWithFixedDelay(() -> {
            int count = this.counter.getAndDecrement();
            if (count > 0) {
                this.printOKButtonText();
            } else if (count == 0) {
                this.printOKButtonText();
                this.okButton.setDisable(false);
            } else if (this.countDownFuture != null) {
                this.countDownFuture.cancel(true);
            }
        }, 3L, 1L, timeUnit);
    }

    protected void printOKButtonText() {
        FxUtil.runInFxThread(() -> {
            if (this.counter.get() > 0) {
                this.okButton.setText(Util.getLabel("commons_ok") + " (" + String.valueOf(this.counter) + ")");
            } else {
                this.okButton.setText(Util.getLabel("commons_ok"));
            }
        });
    }

    public void show() {
        this.stage = new Stage(StageStyle.UTILITY);
        VersionMismatchWarningDialog modalDialog = this;
        Scene scene = new Scene(modalDialog);
        this.stage.setScene(scene);
        this.styleService.registerSceneForStyleSwitching(scene);
        this.styleService.registerWindowForStyleSwitching(scene.getWindow());
        this.stage.setResizable(false);
        this.stage.setTitle(Util.getLabel("versionCheck_newVersion_check"));
        this.stage.show();
        this.stage.setOnCloseRequest(event -> {
            if (this.counter.get() > 0) {
                event.consume();
            }
        });
    }

    public void close() {
        this.stage.close();
    }
}

