/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpBroadcastListener;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class BroadcastQueueListener
implements AmqpBroadcastListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastQueueListener.class);
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker PRIORITY_QUEUE_MARKER = MarkerFactory.getMarker("PRIORITY_QUEUE");
    private static final int QUEUE_CAPACITY = 300000;
    private final AmqpBroadcastListener wrapped;
    private final BlockingQueue<BroadcastProcessing> broadcastQueue;
    private final ExecutorService broadcastExecutor;

    public BroadcastQueueListener(AmqpBroadcastListener wrapped) {
        this(wrapped, Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Comtrader-BroadcastListener").build()), new ArrayBlockingQueue<BroadcastProcessing>(300000));
    }

    protected BroadcastQueueListener(AmqpBroadcastListener wrapped, ExecutorService broadcastExecutor, BlockingQueue<BroadcastProcessing> broadcastQueue) {
        this.wrapped = wrapped;
        this.broadcastExecutor = broadcastExecutor;
        this.broadcastQueue = broadcastQueue;
    }

    protected void startProcessBroadcast() {
        this.broadcastExecutor.execute(this::processBroadcasts);
    }

    private void processBroadcasts() {
        try {
            LOG.info("Processing of broadcasts started. Queue size = {}.", (Object)this.broadcastQueue.size());
            while (!Thread.currentThread().isInterrupted()) {
                this.broadcastQueue.take().runnable().run();
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for next broadcast - exiting. Broadcast queue dump: {}", (Object)this.broadcastQueue);
            Thread.currentThread().interrupt();
        }
    }

    public void stop() {
        this.broadcastExecutor.shutdownNow();
    }

    @Override
    public void processBroadcast(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        this.queueBroadcastProcessing(envelope, properties, body);
    }

    @Override
    public boolean handleAmqpConnectionError(Exception e) {
        return this.wrapped.handleAmqpConnectionError(e);
    }

    private void queueBroadcastProcessing(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        BroadcastProcessing broadcastProcessing = new BroadcastProcessing(() -> this.processBroadcastSynchronously(envelope, properties, body));
        this.putToBroadcastQueue(broadcastProcessing);
        if (PERFORMANCE_LOG.isDebugEnabled()) {
            PERFORMANCE_LOG.debug(PRIORITY_QUEUE_MARKER, Integer.toString(this.broadcastQueue.size()));
        }
    }

    private void putToBroadcastQueue(BroadcastProcessing broadcastProcessing) {
        try {
            this.broadcastQueue.put(broadcastProcessing);
        }
        catch (InterruptedException e) {
            LOG.warn("Thread interrupted because of broadcastProcessingQueue is full.", e);
            Thread.currentThread().interrupt();
        }
    }

    private void processBroadcastSynchronously(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        try {
            this.wrapped.processBroadcast(envelope, properties, body);
        }
        catch (Exception e) {
            LOG.error("Error while processing broadcast.", e);
        }
    }

    protected record BroadcastProcessing(Runnable runnable) {
    }
}

