/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv;

import com.deutscheboerse.comxerv.comtrader.service.csv.ExportWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractExportWriter
implements ExportWriter {
    protected abstract CSVFormat getCsvFormat();

    @Override
    public void writeHeader(Writer writer, List<String> columnNames) throws IOException {
        if (columnNames == null) {
            this.writeLinebreak(writer);
        } else if (!columnNames.isEmpty()) {
            this.writeLine(writer, columnNames);
        }
    }

    @Override
    public void writeDataLine(Writer writer, List<Object> data) throws IOException {
        this.writeLine(writer, data);
    }

    private void writeLinebreak(Writer writer) throws IOException {
        CSVPrinter csvPrinter = new CSVPrinter(writer, this.getCsvFormat());
        csvPrinter.println();
    }

    private void writeLine(Writer writer, List<? extends Object> data) throws IOException {
        CSVPrinter csvPrinter = new CSVPrinter(writer, this.getCsvFormat());
        if (data.size() > 1 && data.get(0) != null && ObjectUtils.isEmpty(data.get(0))) {
            data.set(0, null);
        }
        List<Object> fields = data.stream().map(this::sanitizeString).toList();
        csvPrinter.printRecord(fields);
    }

    @Override
    public void writeFooter(Writer writer) {
    }

    private Object sanitizeString(Object stringToSanitize) {
        if (stringToSanitize == null) {
            return null;
        }
        if (stringToSanitize instanceof String) {
            return this.removeOffendingWhitespaceCharacters((String)stringToSanitize);
        }
        return stringToSanitize;
    }

    private String removeOffendingWhitespaceCharacters(String input) {
        return input.replaceAll("[\\n\\t]", " ");
    }
}

