/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.type.JodaDateFormatType;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.csv.ContinuousTradeExportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.CsvExportWriter;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ContinuousExportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.ContinuousExportTradeListener;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.ContinuousTradeExportState;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.ContinuousTradePrepareExportService;
import com.deutscheboerse.comxerv.comtrader.service.event.ApplicationShutdownEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ContinuousTradeExportServiceImpl
implements ContinuousTradeExportService {
    private static final SettingsService.Settings<Boolean> CONTINUOUS_TRADE_EXPORT_ENABLED_SETTINGS = new SettingsService.Settings<Boolean>("continuousTradeExportEnabled", false);
    private static final SettingsService.Settings<String> CONTINUOUS_TRADE_EXPORT_FILE_PATH_SETTINGS = new SettingsService.Settings<String>("continuousTradeExportFilePath", DEFAULT_FILE_PATH);
    private static final SettingsService.Settings<ContinuousTradeExportService.Mode> CONTINUOUS_TRADE_EXPORT_MODE_SETTINGS = new SettingsService.Settings<ContinuousTradeExportService.Mode>("continuousTradeExportMode", DEFAULT_MODE);
    private final SettingsService.Settings<Integer> continuousTradeExportTradingDaysSettings;
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousTradeExportServiceImpl.class);
    private static final String LOCK_ID = UUID.randomUUID().toString();
    private final SettingsService settingsService;
    private final UserAlertService userAlertService;
    private final ApplicationContext appContext;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TradeService tradeService;
    private ContinuousExportTradeListener continuousExportTradeListener;

    @Inject
    public ContinuousTradeExportServiceImpl(ApplicationContext appContext) {
        this.appContext = appContext;
        this.settingsService = appContext.getService(SettingsService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.scheduledExecutorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.tradeService = appContext.getService(TradeService.class);
        this.continuousTradeExportTradingDaysSettings = new SettingsService.Settings<Integer>("continuousTradeExportTradingDays", Integer.valueOf(1)){

            @Override
            public Integer getDefaultValue() {
                return ContinuousTradeExportServiceImpl.this.getDefaultTradingDays();
            }
        };
        appContext.getService(EventBus.class).register(this);
    }

    @Subscribe
    public void initializeContinuousExport(SettingsLoadedEvent settingsLoadedEvent) {
        Future<Boolean> exportEnabled = this.setContinuousTradeExportState(this.getCurrentSettings());
        Runnable task = () -> {
            try {
                exportEnabled.get(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Thread interrupted", e);
                this.deactivateContinuousTradeExport();
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException | TimeoutException e) {
                LOG.error("Error while enabling trade export", e);
                this.deactivateContinuousTradeExport();
            }
        };
        this.scheduledExecutorService.submit(task);
    }

    private void deactivateContinuousTradeExport() {
        ContinuousTradeExportState currentSettings = this.getCurrentSettings();
        this.setContinuousTradeExportState(new ContinuousTradeExportState(false, currentSettings.getExportFile(), currentSettings.getMode(), currentSettings.getTradingDays()));
    }

    @Subscribe
    public void handle(ApplicationShutdownEvent applicationShutdownEvent) {
        this.removeLockFile(this.getCurrentSettings().getExportFile());
    }

    @Subscribe
    public void closeContinuousExport(LogoutEvent logoutEvent) {
        if (this.getContinuousTradeExportState().isEnabled()) {
            this.disableContinuousTradeExport(true);
        }
    }

    @Override
    public ContinuousTradeExportState getContinuousTradeExportState() {
        return this.getCurrentSettings();
    }

    @Override
    public Integer getDefaultTradingDays() {
        Exchange exchange = this.appContext.getService(ActiveExchange.class).getActiveExchange().get();
        return exchange != null ? exchange.getSystemInfo().getContractStoreTimeInDays() : 1;
    }

    private ContinuousTradeExportState getCurrentSettings() {
        Boolean enabled = this.settingsService.loadSettings(CONTINUOUS_TRADE_EXPORT_ENABLED_SETTINGS);
        File exportFile = new File(this.settingsService.loadSettings(CONTINUOUS_TRADE_EXPORT_FILE_PATH_SETTINGS));
        ContinuousTradeExportService.Mode mode = this.settingsService.loadSettings(CONTINUOUS_TRADE_EXPORT_MODE_SETTINGS);
        Integer exportedTradingDays = this.settingsService.loadSettings(this.continuousTradeExportTradingDaysSettings);
        return new ContinuousTradeExportState(enabled, exportFile, mode, exportedTradingDays);
    }

    @Override
    public Future<Boolean> setContinuousTradeExportState(ContinuousTradeExportState continuousTradeExportState) {
        Future<Boolean> result = continuousTradeExportState.isEnabled() ? this.enableContinuousTradeExport(continuousTradeExportState.getExportFile(), continuousTradeExportState.getMode(), continuousTradeExportState.getTradingDays()) : this.disableContinuousTradeExport(true);
        this.saveSettings(continuousTradeExportState);
        return result;
    }

    private Future<Boolean> enableContinuousTradeExport(final File file, final ContinuousTradeExportService.Mode mode, final int tradingDays) {
        SettableFuture<Boolean> result = SettableFuture.create();
        this.disableContinuousTradeExport(false);
        this.scheduledExecutorService.submit(() -> {
            if (this.createLockFile(file)) {
                try {
                    this.prepareNewFileForContinuousExport(file);
                    LOG.info("Exporting trades to " + file.getAbsolutePath());
                    ContinuousExportService continuousExportService = new ContinuousExportService(file, new CsvExportWriter(), this.scheduledExecutorService);
                    ContinuousTradePrepareExportService continuousTradePrepareExportService = this.appContext.getService(ContinuousTradePrepareExportService.class);
                    DateTime date = this.appContext.getService(TimeService.class).getLocalTime();
                    continuousExportService.writeHeaders("OT " + JodaDateFormatType.FORMAT_WITH_MINUS_YYYY_MM_DD.printJustDateDateFormat(date), continuousTradePrepareExportService.getColumnNames());
                    this.continuousExportTradeListener = new ContinuousExportTradeListener(this.appContext, continuousExportService){

                        @Override
                        public void handleExportError(Exception e) {
                            ContinuousTradeExportServiceImpl.this.deactivateContinuousTradeExport();
                            ContinuousTradeExportServiceImpl.this.userAlertService.showConfirmationDialog(Util.getLabel("continuousTradeExport_writeError_windowHeader"), Util.getLabel("continuousTradeExport_writeError_message", file.getAbsoluteFile()), UserAlertService.Flag.ERROR);
                        }

                        @Override
                        public boolean isTradeInScope(HalfTrade trade) {
                            DateTime oldestAllowed = ContinuousTradeExportServiceImpl.this.appContext.getService(TimeService.class).getServerTime().minusDays(tradingDays).withTimeAtStartOfDay();
                            return (mode == ContinuousTradeExportService.Mode.ALL_TRADES || ContinuousTradeExportServiceImpl.this.tradeService.isOwnUserTrade(trade)) && trade.getTimeStamp().isAfter(oldestAllowed);
                        }
                    };
                    result.set(true);
                }
                catch (IOException e) {
                    LOG.error("Could not initialize continuous trade export.", e);
                    this.deactivateContinuousTradeExport();
                    result.setException(e);
                }
            } else {
                this.userAlertService.showConfirmationDialog(Util.getLabel("commons_error"), Util.getLabel("continuousTradeExport_locked_message", this.getCurrentSettings().getExportFile().getAbsolutePath()), UserAlertService.Flag.ERROR, UserAlertService.Flag.OK);
                result.set(false);
            }
        });
        return result;
    }

    private boolean createLockFile(File file) {
        File lockfile = new File(file.getPath() + ".lck");
        try {
            if (!lockfile.exists() && lockfile.createNewFile()) {
                PrintWriter writer = new PrintWriter(lockfile, "UTF-8");
                writer.print(LOCK_ID);
                writer.close();
                return true;
            }
            return this.isOwnLockFile(lockfile);
        }
        catch (IOException e) {
            LOG.error("Failed to create logfile", e);
            return false;
        }
    }

    private boolean isOwnLockFile(File lockFile) throws IOException {
        String content = new String(Files.readAllBytes(lockFile.toPath()));
        return LOCK_ID.equals(content.trim());
    }

    private boolean removeLockFile(File file) {
        File lockFile = new File(file.getPath() + ".lck");
        try {
            return lockFile.exists() && this.isOwnLockFile(lockFile) && lockFile.delete();
        }
        catch (IOException e) {
            LOG.error("Failed to delete logfile", e);
            return false;
        }
    }

    private Future<Boolean> disableContinuousTradeExport(boolean freeLock) {
        SettableFuture<Boolean> result = SettableFuture.create();
        if (freeLock) {
            this.removeLockFile(this.getCurrentSettings().getExportFile());
        }
        this.scheduledExecutorService.submit(() -> {
            if (this.continuousExportTradeListener != null) {
                try {
                    this.continuousExportTradeListener.close();
                    this.continuousExportTradeListener = null;
                }
                catch (Exception e) {
                    LOG.error("Could not close export file.", e);
                    result.setException(e);
                }
            }
            result.set(false);
        });
        return result;
    }

    private void saveSettings(ContinuousTradeExportState continuousTradeExportState) {
        this.settingsService.storeSettings(CONTINUOUS_TRADE_EXPORT_ENABLED_SETTINGS, continuousTradeExportState.isEnabled());
        this.settingsService.storeSettings(CONTINUOUS_TRADE_EXPORT_FILE_PATH_SETTINGS, continuousTradeExportState.getExportFile().getAbsolutePath());
        this.settingsService.storeSettings(CONTINUOUS_TRADE_EXPORT_MODE_SETTINGS, continuousTradeExportState.getMode());
        this.settingsService.storeSettings(this.continuousTradeExportTradingDaysSettings, continuousTradeExportState.getTradingDays());
    }

    private void prepareNewFileForContinuousExport(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete previous trade export file: " + file.getAbsolutePath());
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create new trade export file: " + file.getAbsolutePath());
        }
    }
}

