/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.EntityColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ExportColumn;
import java.util.function.BinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContractColumn<E>
extends EntityColumn<Contract>
implements ExportColumn<Contract, E> {
    private static final Logger LOG = LoggerFactory.getLogger(ContractColumn.class);

    public ContractColumn(String header, ApplicationContext applicationContext) {
        super(header, Contract.class, applicationContext);
    }

    public Contract parseContractValue(String data) {
        ContractQueries contractQueries = this.applicationContext.getService(ContractQueries.class);
        return contractQueries.findActiveByName(data).getFirst().orElse(null);
    }

    @Override
    public String getStringValue(Contract value) {
        return value.getName();
    }

    public static BinaryOperator<Contract> duplicateContractsWarning() {
        return (element, otherElement) -> {
            if (element.getProduct().isLinkedOrderProduct()) {
                LOG.warn("Duplicate contracts found for linked product: {} ({}) and {} ({}), returning remote one.", element, element.getProduct(), otherElement, otherElement.getProduct());
                return otherElement;
            }
            LOG.warn("Duplicate contracts found: {} ({}) and {} ({}), returning first one.", element, element.getProduct(), otherElement, otherElement.getProduct());
            return element;
        };
    }
}

