/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.info;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.info.CpuInfo;
import com.deutscheboerse.comxerv.comtrader.service.info.EnvironmentInfo;
import com.deutscheboerse.comxerv.comtrader.service.info.HardwareInfo;
import com.deutscheboerse.comxerv.comtrader.service.info.MemoryInfo;
import com.deutscheboerse.comxerv.comtrader.service.info.ScreenInfo;
import com.deutscheboerse.comxerv.comtrader.service.info.SessionInfo;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.TextStringBuilder;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import oshi.SystemInfo;

@Singleton
public class InfoLogger {
    private static final Logger LOG = LoggerFactory.getLogger(InfoLogger.class);
    private static final int INTERNET_REACHABLE_TIMEOUT = 100;
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker CPU_MARKER = MarkerFactory.getMarker("CPU");
    private static final DecimalFormat CPU_LOAD_FORMAT = new DecimalFormat("#0.00");
    private final ApplicationContext appContext;
    private final CpuInfo cpuInfo;
    private final MemoryInfo memoryInfo;
    private final ScreenInfo screenInfo;
    private final EnvironmentInfo environmentInfo;
    private final HardwareInfo hardwareInfo;
    private final SessionInfo sessionInfo;
    private final Monitor monitor;
    protected boolean internetReachable = false;
    private final Proxy webProxy;

    @Inject
    public InfoLogger(ApplicationContext appContext, CpuInfo cpuInfo, MemoryInfo memoryInfo, ScreenInfo screenInfo, EnvironmentInfo environmentInfo, HardwareInfo hardwareInfo, SessionInfo sessionInfo, Monitor monitor) {
        this.appContext = appContext;
        this.cpuInfo = cpuInfo;
        this.memoryInfo = memoryInfo;
        this.screenInfo = screenInfo;
        this.environmentInfo = environmentInfo;
        this.hardwareInfo = hardwareInfo;
        this.sessionInfo = sessionInfo;
        this.monitor = monitor;
        URL proxyUrl = environmentInfo.getHttpProxyUrl();
        this.webProxy = proxyUrl == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort()));
    }

    public void logStartUpInfo() {
        LOG.info("PROXY: {}", (Object)this.environmentInfo.getProxyInfo());
        this.configurationCheck();
    }

    private void configurationCheck() {
        TextStringBuilder tsb = new TextStringBuilder();
        if (!this.is64BitVM()) {
            tsb.appendln("- 32 bit Java");
        }
        if (Runtime.getRuntime().maxMemory() < 0x40000000L) {
            tsb.appendln("- less then 1GB memory");
        }
        if ("Windows 7".equals(System.getProperty("os.name"))) {
            tsb.appendln("- MS Windows 7");
        }
        if (tsb.isNotEmpty()) {
            String message = "Unsupported configuration detected (see MFG140):" + System.lineSeparator() + tsb.build();
            this.appContext.getService(UserAlertService.class).showConfirmationDialog(Util.getLabel("config_check_title"), message, UserAlertService.Flag.WARNING);
        }
    }

    private boolean is64BitVM() {
        String bits = System.getProperty("sun.arch.data.model", "?");
        if (bits.equals("64")) {
            return true;
        }
        if (bits.equals("?")) {
            return System.getProperty("java.vm.name").toLowerCase().indexOf("64") >= 0;
        }
        return false;
    }

    public void logConnectivityTest() {
        this.internetReachable = this.internetConnectivityTest();
    }

    public void probeInternetConnectivity() {
        if (this.internetReachable) {
            this.internetConnectivityTest();
        } else {
            LOG.warn("Internet connectivity not probed, as it failed at last login");
        }
    }

    private boolean internetConnectivityTest() {
        String connectivityCheckUrl = this.appContext.getService(ApplicationConfigurationService.class).getApplicationProperty("connectivity.check.url");
        if (StringUtils.isNotEmpty(connectivityCheckUrl)) {
            try {
                if (InetAddress.getByName(connectivityCheckUrl).isReachable(100)) {
                    LOG.info("Internet ({}) reachable!", (Object)connectivityCheckUrl);
                    return true;
                }
                if (this.internetConnectivityHttpTest(connectivityCheckUrl)) {
                    return true;
                }
            }
            catch (IOException e) {
                LOG.error("Unable to test internet connectivity", e);
            }
        }
        LOG.warn("Internet ({}) not reachable!", (Object)connectivityCheckUrl);
        return false;
    }

    private boolean internetConnectivityHttpTest(String connectivityCheckUrl) {
        String httpUrl = "http://" + connectivityCheckUrl;
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = this.webProxy != null ? (HttpURLConnection)url.openConnection(this.webProxy) : (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(100);
            connection.connect();
            connection.disconnect();
            LOG.info("Internet ({}) reachable!", (Object)httpUrl);
            return true;
        }
        catch (IOException e) {
            LOG.error("Unable to test internet connectivity", e);
            return false;
        }
    }

    public void logSystemInfo() {
        this.logEnvironmentInfo();
        this.logHardware();
        this.logScreenInfo();
        this.logUptime();
        this.logSessions();
    }

    private void logUptime() {
        LOG.info("Uptime: {}", (Object)new Duration(ManagementFactory.getRuntimeMXBean().getUptime()));
    }

    private void logSessions() {
        LOG.info("Session: {}", (Object)this.sessionInfo.getFormattedSessionCreationTime());
    }

    private void logHardware() {
        LOG.info("CPU: {}", (Object)this.hardwareInfo.getCpuInfo());
        this.monitor.totalMemory(new SystemInfo().getHardware().getMemory().getTotal());
        LOG.info("RAM: {}", (Object)this.hardwareInfo.getRamInfo());
    }

    public void logResourceInfo() {
        this.logCpuInfo();
        this.logMemory();
    }

    public void logPerformanceInfo() {
        this.monitor.processCpuLoad(this.cpuInfo.getProcessCpuLoad());
        if (PERFORMANCE_LOG.isDebugEnabled()) {
            PERFORMANCE_LOG.debug(CPU_MARKER, CPU_LOAD_FORMAT.format(this.cpuInfo.getProcessCpuLoad()));
        }
    }

    private void logEnvironmentInfo() {
        LOG.info("CT: {}", (Object)this.environmentInfo.getComTraderInfo());
        LOG.info("OS: {}", (Object)this.environmentInfo.getOsInfo());
        LOG.info("JVM: {}", (Object)this.environmentInfo.getJvmInfo());
        LOG.info("Clientsystem Timezone: {}", (Object)this.environmentInfo.getTimeZone());
        LOG.info("Session environment: {}", (Object)this.environmentInfo.getSessionName());
    }

    private void logScreenInfo() {
        if (LOG.isInfoEnabled()) {
            List<String> screenResolutions = this.screenInfo.getScreenResolutions();
            LOG.info("Screen info ({}): {}", (Object)screenResolutions.size(), (Object)screenResolutions.stream().collect(Collectors.joining(", ")));
        }
    }

    private void logMemory() {
        LOG.info("Memory usage: {}", (Object)this.memoryInfo.getMemoryStatus());
        this.monitor.usedMemory(this.memoryInfo.usedMemory());
        this.monitor.maxMemory(this.memoryInfo.maxMemory());
    }

    private void logCpuInfo() {
        this.monitor.processCpuLoad(this.cpuInfo.getProcessCpuLoad());
        this.monitor.systemCpuLoad(this.cpuInfo.getSystemCpuLoad());
        if (LOG.isInfoEnabled()) {
            LOG.info("CPU load process/system: {}/{}", (Object)CPU_LOAD_FORMAT.format(this.cpuInfo.getProcessCpuLoad()), (Object)CPU_LOAD_FORMAT.format(this.cpuInfo.getSystemCpuLoad()));
        }
    }
}

