/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.listener;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.EntityListener;
import com.deutscheboerse.comxerv.comtrader.entities.session.LogoutNotification;
import com.deutscheboerse.comxerv.comtrader.entities.session.LogoutType;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LogoutNotificationListener
implements EntityListener<LogoutNotification> {
    private static final Logger LOG = LoggerFactory.getLogger(LogoutNotificationListener.class);
    private final AtomicBoolean isLogoutNotificationSync = new AtomicBoolean(false);
    private final ApplicationContext applicationContext;

    @Inject
    public LogoutNotificationListener(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Class<LogoutNotification> getEntityClass() {
        return LogoutNotification.class;
    }

    @Override
    public void handleBroadcastEntity(LogoutNotification logoutNotification) {
        LOG.info("Logout notification: {}", (Object)logoutNotification);
        Session session = this.getBackendConnectionGateway().getSession();
        String user = session != null ? session.getConnectionParameters().getRabbitUser() : "";
        String logoutMessage = null;
        if (LogoutType.CONNECTION_FAILED == logoutNotification.getLogoutType()) {
            String msg1 = StringUtils.isEmpty(logoutNotification.getMessage()) ? "" : logoutNotification.getMessage();
            logoutMessage = Util.getLabel("connectionFailedNotification") + " " + msg1;
        }
        this.getBackendConnectionGateway().logout(logoutNotification.getLogoutType(), logoutMessage, null);
        switch (logoutNotification.getLogoutType()) {
            case INTERNAL_QUIET: 
            case CONNECTION_FAILED: {
                break;
            }
            case EXTERNAL_DELETED: {
                this.showLogoutMessage(Util.getLabel("userDeletedNotification", user));
                break;
            }
            case EXTERNAL_SUSPENDED: {
                this.showLogoutMessage(Util.getLabel("userSuspendedNotification", user));
                break;
            }
            case EXTERNAL_PASSWORD_RESET: {
                this.showLogoutMessage(Util.getLabel("userPasswordResetNotification", user));
                break;
            }
            case EXTERNAL_PASSWORD_CHANGE: {
                this.showLogoutMessage(Util.getLabel("userPasswordChangeNotification", user));
                break;
            }
            case EXTERNAL_PASSWORD_CHANGE_ERROR: {
                this.showLogoutMessage(Util.getLabel("userPasswordChangeErrorNotification", user));
                break;
            }
            case EXTERNAL_ADMIN_MODIFICATION: {
                this.showLogoutMessage(Util.getLabel("userModifiedAndKickedOut", user));
                break;
            }
            case EXTERNAL_ACCOUNT_CHANGE: {
                this.showLogoutMessage(Util.getLabel("accountChangeNotification", user));
                break;
            }
            case EXTERNAL_TERMINATED_BY_CORE: {
                this.showLogoutMessage(Util.getLabel("connectionTerminatedByServer", user));
                break;
            }
            case EXTERNAL_LOGGED_OUT: {
                if (StringUtils.isEmpty(logoutNotification.getMessage())) {
                    this.showLogoutMessage(Util.getLabel("logoutNotificationText"));
                    break;
                }
                this.showLogoutMessage(Util.getLabel("externalLoggedOutNotification", logoutNotification.getMessage()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)logoutNotification.getLogoutType()));
            }
        }
    }

    private void showLogoutMessage(String msg) {
        if (this.isLogoutNotificationSync.compareAndSet(false, true)) {
            FxUtil.runInFxThread(() -> {
                this.getAlertService().showConfirmationDialog(Util.getLabel("commons_forceLogout"), msg, UserAlertService.Flag.WARNING, UserAlertService.Flag.BLOCKING);
                this.isLogoutNotificationSync.set(false);
            });
        }
    }

    private UserAlertService getAlertService() {
        return this.applicationContext.getService(UserAlertService.class);
    }

    private BackendConnectionGateway getBackendConnectionGateway() {
        return this.applicationContext.getService(BackendConnectionGateway.class);
    }
}

