/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.preference;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesEntry;
import java.util.Optional;

public class SerializableOrderPreferencesEntry {
    private final String product;
    private final String contract;
    private final LongDisplayValue quantity;
    private final OrderType type;
    private final String deliveryAreaId;
    private final String accountType;
    private final ValidityRestriction validityRestriction;
    private final OpenOrClose openOrClose;

    public SerializableOrderPreferencesEntry(OrderPreferencesEntry orderPreferencesEntry) {
        this.product = orderPreferencesEntry.getProduct();
        this.contract = orderPreferencesEntry.getContract();
        this.quantity = orderPreferencesEntry.getQuantity();
        this.type = orderPreferencesEntry.getOrderType();
        this.deliveryAreaId = Optional.ofNullable(orderPreferencesEntry.getDeliveryArea()).map(BroadcastEntity::getId).orElse(null);
        this.accountType = orderPreferencesEntry.getAccountType();
        this.validityRestriction = orderPreferencesEntry.getValidityRestriction();
        this.openOrClose = orderPreferencesEntry.getOpenOrClose();
    }

    public String getProduct() {
        return this.product;
    }

    public String getContract() {
        return this.contract;
    }

    public LongDisplayValue getQuantity() {
        return this.quantity;
    }

    public OrderType getOrderType() {
        return this.type;
    }

    public String getDeliveryAreaId() {
        return this.deliveryAreaId;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public ValidityRestriction getValidityRestriction() {
        return this.validityRestriction;
    }

    public OpenOrClose getOpenOrClose() {
        return this.openOrClose;
    }
}

