/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileServiceAuthenticationException;
import com.deutscheboerse.comxerv.comtrader.service.profile.RemoteProfileServiceException;
import com.deutscheboerse.comxerv.comtrader.service.remote.RemoteServiceProxy;
import com.deutscheboerse.comxerv.comtrader.util.RemoteServiceUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileService;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.RemoteProfileService;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.data.Profile;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.transport.http.HTTPException;

@Singleton
public class RemoteProfileServiceProxy
extends RemoteServiceProxy<RemoteProfileService>
implements ProfileService {
    private final RemoteServiceUtil remoteServiceUtil;

    @Inject
    public RemoteProfileServiceProxy(ApplicationContext applicationContext) {
        super(applicationContext, RemoteProfileService.class, "RemoteProfileServiceV3");
        this.remoteServiceUtil = applicationContext.getService(RemoteServiceUtil.class);
    }

    @Override
    public boolean profileExists(String exchangeId, String userName, String environmentId) throws ProfileServiceException {
        try {
            return ((RemoteProfileService)this.getRemoteService()).profileExists(exchangeId, userName, environmentId);
        }
        catch (WebServiceException e) {
            throw this.translateRemoteServiceException(e);
        }
    }

    @Override
    public void createProfile(Profile profile) throws ProfileServiceException {
        try {
            ((RemoteProfileService)this.getRemoteService()).createProfile(profile);
        }
        catch (WebServiceException e) {
            throw this.translateRemoteServiceException(e);
        }
    }

    @Override
    public Profile loadProfile(String exchangeId, String userName, String environmentId) throws ProfileServiceException {
        try {
            return ((RemoteProfileService)this.getRemoteService()).loadProfile(exchangeId, userName, environmentId);
        }
        catch (WebServiceException e) {
            throw this.translateRemoteServiceException(e);
        }
    }

    @Override
    public void storeProfile(Profile profile) throws ProfileServiceException {
        try {
            ((RemoteProfileService)this.getRemoteService()).storeProfile(profile);
        }
        catch (WebServiceException e) {
            throw this.translateRemoteServiceException(e);
        }
    }

    private RuntimeException translateRemoteServiceException(WebServiceException exception) {
        String message = Util.getLabel("remote_profile_Service_connection_error");
        Throwable cause = exception.getCause();
        if (cause != null) {
            Fault faultEx;
            String hostInfo;
            try {
                hostInfo = new URL(this.remoteServiceUtil.getPrimaryProfileStorageUrl()).getHost();
            }
            catch (MalformedURLException e) {
                hostInfo = cause.getMessage();
            }
            if (cause instanceof UnknownHostException) {
                message = Util.getLabel("remote_profile_Service_unknown_host", hostInfo);
            } else if (cause instanceof SocketTimeoutException) {
                message = Util.getLabel("remote_profile_Service_timeout");
            } else if (cause instanceof NoRouteToHostException) {
                message = Util.getLabel("remote_profile_Service_no_route_to_host", hostInfo);
            } else if (cause instanceof SocketException) {
                message = Util.getLabel("remote_profile_Service_network_error", cause.getMessage());
            } else if (cause instanceof HTTPException) {
                HTTPException httpEx = (HTTPException)cause;
                if (httpEx.getResponseCode() == 401) {
                    return new ProfileServiceAuthenticationException(cause.getMessage(), cause);
                }
            } else if (cause instanceof Fault && (faultEx = (Fault)cause).getStatusCode() == 500) {
                message = Util.getLabel("remote_profile_Service_internal_error");
            }
        }
        return new RemoteProfileServiceException(message, exception);
    }
}

