/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.statistic;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatistics;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatisticsImpl;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatisticsService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class OwnVolumeStatisticsServiceImpl
implements OwnVolumeStatisticsService {
    private final LoadingCache<Orderbook, OwnVolumeStatistics> ownVolumeStatisticsLoadingCache;

    @Inject
    public OwnVolumeStatisticsServiceImpl(final ApplicationContext applicationContext) {
        this.ownVolumeStatisticsLoadingCache = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<Orderbook, OwnVolumeStatistics>(this){

            @Override
            public OwnVolumeStatistics load(Orderbook key) throws Exception {
                return new OwnVolumeStatisticsImpl(key, applicationContext);
            }
        });
    }

    @Override
    public OwnVolumeStatistics forOrderbook(Orderbook orderbook) {
        return this.ownVolumeStatisticsLoadingCache.getUnchecked(orderbook);
    }
}

