/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api.type;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MessageVariableType {
    TRADER_ID(0),
    TSO_SHORT_NAME(1),
    BUY_OR_SELL(2),
    CONTRACT_NAME(3),
    QUANTITY_CONVERTED(4),
    PRICE(5),
    TEXT(6),
    REMAINING_QUANTITY_CONVERTED(7),
    FILENAME(8),
    BALANCING_GROUP(9),
    CONTRACT_TRADING_START_TIME(10),
    CONTRACT_TRADING_END_TIME(11),
    DD_MM_FORMATTED_DATE(12),
    MESSAGE_IDENTIFICATION(13),
    VERSION_NUMBER(14),
    PRODUCT_GROUP_NAME(15),
    YYYY_MM_DD_MMHH_FORMATTED_DATE1(16),
    YYYY_MM_DD_MMHH_FORMATTED_DATE2(17),
    QUANTITY_UNIT(18),
    MARKET_AREA(19),
    MEMBER(20),
    TOTAL_QUANTITY_FOR_ICEBERG_ORDERS(21),
    STOP_PRICE_FOR_STOP_LIMIT_ORDERS(22),
    BORDER_IDENTIFICATION(23),
    ACTIVATION_POINT(24),
    EXPIRY_POINT(25),
    THROTTLING_STATUS(26),
    THROTTLING_CHANGE_TIME(27),
    THROTTLING_SHORT_RULE_DESC(28),
    THROTTLING_LONG_RULE_DESC(29),
    LAST_USER_ID(30),
    CLIENT_CORRELATION_ID(31),
    PRODUCT_ID(32),
    CONTRACT_ID(99000),
    UNFORMATTED_PRICE(99001),
    UNFORMATTED_STOP_PRICE(99002),
    UNFORMATTED_QUANTITY(99003),
    UNFORMATTED_QUANTITY_TOTAL(99004),
    UNFORMATTED_QUANTITY_REM(99005);

    private static final Map<Integer, MessageVariableType> ID_TO_MESSAGE_VARIABLE_TYPE;
    private final int id;

    private MessageVariableType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static MessageVariableType getById(int id) {
        return ID_TO_MESSAGE_VARIABLE_TYPE.get(id);
    }

    static {
        ID_TO_MESSAGE_VARIABLE_TYPE = Arrays.stream(MessageVariableType.values()).collect(Collectors.collectingAndThen(Collectors.toMap(MessageVariableType::getId, Function.identity()), Collections::unmodifiableMap));
    }
}

