/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util;

import java.util.Map;
import java.util.WeakHashMap;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class ModalStages {
    private static final Map<Stage, EventBlocker> modalStages = new WeakHashMap<Stage, EventBlocker>();
    private static final ObservableList<Window> allStages = Window.getWindows();
    private static final ColorAdjust DISABLE_EFFECT = new ColorAdjust(0.0, -1.0, 0.2, -0.5);

    private ModalStages() {
    }

    public static void makeModal(Stage stage) {
        EventBlocker eventBlocker = new EventBlocker(stage);
        modalStages.put(stage, null);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.addEventFilter(WindowEvent.WINDOW_SHOWN, event -> ModalStages.disableAllStages(eventBlocker));
        stage.addEventFilter(WindowEvent.WINDOW_HIDDEN, event -> ModalStages.enableAllStages(eventBlocker));
        stage.setAlwaysOnTop(true);
    }

    private static void disableAllStages(EventBlocker eventBlocker) {
        allStages.forEach(stage -> ModalStages.disableStage(stage, eventBlocker));
        allStages.addListener(eventBlocker);
    }

    private static void disableStage(Window window, EventBlocker eventBlocker) {
        if (window instanceof Stage && !modalStages.containsKey(window)) {
            window.addEventFilter(EventType.ROOT, eventBlocker);
            window.getScene().getRoot().setEffect(DISABLE_EFFECT);
        }
    }

    private static void enableAllStages(EventBlocker eventBlocker) {
        allStages.forEach(stage -> ModalStages.enableStage(stage, eventBlocker));
        allStages.removeListener(eventBlocker);
    }

    private static void enableStage(Window window, EventBlocker eventBlocker) {
        if (window instanceof Stage) {
            window.removeEventFilter(EventType.ROOT, eventBlocker);
            window.getScene().getRoot().setEffect(null);
        }
    }

    private static final class EventBlocker
    implements EventHandler,
    ListChangeListener<Window> {
        private final Stage stage;

        public EventBlocker(Stage stage) {
            this.stage = stage;
        }

        public void handle(Event event) {
            this.stage.toFront();
            if (!MouseEvent.MOUSE_EXITED_TARGET.equals(event.getEventType())) {
                event.consume();
            }
        }

        @Override
        public void onChanged(ListChangeListener.Change<? extends Window> c) {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().forEach(stage -> ModalStages.disableStage(stage, this));
            }
        }
    }
}

