/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control.table;

import com.deutscheboerse.ui.jfx.util.control.table.TableSourceData;
import com.deutscheboerse.ui.jfx.util.event.DeselectionEventHandler;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;

public class DraggableTableRow<S>
extends TableRow<S> {
    protected static final DataFormat DRAGGED_ROW_INDEX_DATA_FORMAT = new DataFormat(DraggableTableRow.class.getName());

    public DraggableTableRow() {
        this.setOnDragDetected(this::onDragDetected);
        this.setOnDragOver(this::onDragOver);
        this.setOnDragDropped(this::onDragDropped);
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, new DeselectionEventHandler(this));
        this.setOnDragEntered(this::onDragEntered);
        this.setOnDragExited(event -> this.setStyle("-fx-border-width: 0 0 0 0; -fx-border-color: table-view-row-selected-background-color;"));
    }

    public static <S> Callback<TableView<S>, TableRow<S>> asRowFactory() {
        return param -> new DraggableTableRow();
    }

    private void onDragEntered(DragEvent event) {
        int dropIndex;
        Dragboard dragboard = event.getDragboard();
        int draggedIndex = (Integer)dragboard.getContent(DRAGGED_ROW_INDEX_DATA_FORMAT);
        int n = dropIndex = this.isEmpty() ? this.getTableView().getItems().size() : this.getIndex();
        if (draggedIndex > dropIndex) {
            this.setStyle("-fx-border-width: 2px 0 0 0; -fx-border-color: table-view-row-selected-background-color;");
        } else {
            this.setStyle("-fx-border-width: 0 0 2px 0; -fx-border-color: table-view-row-selected-background-color;");
        }
    }

    protected void onDragDetected(MouseEvent event) {
        if (!this.isEmpty() && this.getItem() != null) {
            Dragboard dragboard = this.startDragAndDrop(TransferMode.MOVE);
            dragboard.setDragView(this.snapshot(null, null));
            this.startRowDrag(event, dragboard);
        }
    }

    protected void startRowDrag(MouseEvent mouseEvent, Dragboard dragboard) {
        ClipboardContent cc = new ClipboardContent();
        cc.put(DRAGGED_ROW_INDEX_DATA_FORMAT, this.getIndex());
        dragboard.setContent(cc);
        mouseEvent.consume();
    }

    protected void onDragOver(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasContent(DRAGGED_ROW_INDEX_DATA_FORMAT) && this.getIndex() != ((Integer)db.getContent(DRAGGED_ROW_INDEX_DATA_FORMAT)).intValue() && this.getItem() != null) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            event.consume();
        }
    }

    protected void onDragDropped(DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        if (dragboard.hasContent(DRAGGED_ROW_INDEX_DATA_FORMAT)) {
            int draggedIndex = (Integer)dragboard.getContent(DRAGGED_ROW_INDEX_DATA_FORMAT);
            Object draggedRow = this.getDataForUpdate().remove(this.getOriginalIndex(draggedIndex));
            int dropIndex = this.isEmpty() ? this.getTableView().getItems().size() : this.getIndex();
            this.getDataForUpdate().add(this.getOriginalIndex(dropIndex), draggedRow);
            event.setDropCompleted(true);
            this.getTableView().getSelectionModel().select(dropIndex);
            event.consume();
        }
    }

    private int getOriginalIndex(int filteredIndex) {
        if (this.getTableView().getItems() instanceof FilteredList) {
            if (filteredIndex >= this.getTableView().getItems().size()) {
                return this.getTableView().getItems().size();
            }
            return ((FilteredList)this.getTableView().getItems()).getSourceIndex(filteredIndex);
        }
        return filteredIndex;
    }

    private ObservableList<S> getDataForUpdate() {
        if (this.getTableView() instanceof TableSourceData) {
            return ((TableSourceData)((Object)this.getTableView())).getData();
        }
        return this.getTableView().getItems();
    }
}

