/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.factory.bag.MutableBagFactory;
import org.eclipse.collections.impl.bag.mutable.HashBag;

@ServiceProvider(value=MutableBagFactory.class)
public class MutableBagFactoryImpl
implements MutableBagFactory {
    public static final MutableBagFactory INSTANCE = new MutableBagFactoryImpl();

    @Override
    public <T> MutableBag<T> empty() {
        return HashBag.newBag();
    }

    @Override
    public <T> MutableBag<T> with(T ... elements) {
        return HashBag.newBagWith(elements);
    }

    @Override
    public <T> MutableBag<T> withAll(Iterable<? extends T> items) {
        return HashBag.newBag(items);
    }

    @Override
    public <T> MutableBag<T> fromStream(Stream<? extends T> stream) {
        return stream.collect(Collectors.toCollection(HashBag::newBag));
    }

    @Override
    public <T> MutableBag<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return HashBag.newBag(capacity);
    }
}

