/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;

public final class DistinctIterator<T>
implements Iterator<T> {
    private static final Object NULL = new Object();
    private final Iterator<T> iterator;
    private final MutableSet<T> seenSoFar = Sets.mutable.empty();
    private Object next = NULL;

    public DistinctIterator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public DistinctIterator(Iterator<T> iterator2) {
        this.iterator = iterator2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a distinct iterator");
    }

    @Override
    public boolean hasNext() {
        if (this.next != NULL) {
            return true;
        }
        while (this.iterator.hasNext()) {
            T temp = this.iterator.next();
            if (!this.seenSoFar.add(temp)) continue;
            this.next = temp;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.next != NULL || this.hasNext()) {
            Object temp = this.next;
            this.next = NULL;
            return (T)temp;
        }
        throw new NoSuchElementException();
    }
}

