/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableByteListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableByteArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableByteEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableByteSingletonList;

@ServiceProvider(value=ImmutableByteListFactory.class)
public class ImmutableByteListFactoryImpl
implements ImmutableByteListFactory {
    public static final ImmutableByteListFactory INSTANCE = new ImmutableByteListFactoryImpl();

    @Override
    public ImmutableByteList empty() {
        return ImmutableByteEmptyList.INSTANCE;
    }

    @Override
    public ImmutableByteList of() {
        return this.empty();
    }

    @Override
    public ImmutableByteList with() {
        return this.empty();
    }

    @Override
    public ImmutableByteList of(byte one) {
        return this.with(one);
    }

    @Override
    public ImmutableByteList with(byte one) {
        return new ImmutableByteSingletonList(one);
    }

    @Override
    public ImmutableByteList of(byte ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableByteList with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableByteArrayList.newListWith(items);
    }

    @Override
    public ImmutableByteList ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableByteList withAll(ByteIterable items) {
        if (items instanceof ImmutableByteList) {
            return (ImmutableByteList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableByteArrayList.newList(items);
    }

    @Override
    public ImmutableByteList ofAll(Iterable<Byte> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableByteList withAll(Iterable<Byte> iterable) {
        return ByteLists.mutable.withAll(iterable).toImmutable();
    }
}

