/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.IndexRange;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.HitInfo;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.TextFlowLayout;
import org.fxmisc.richtext.TextFlowSpan;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;

class TextFlowExt
extends TextFlow {
    private TextFlowLayout layout;

    TextFlowExt() {
    }

    private TextFlowLayout textLayout() {
        if (this.layout == null) {
            this.layout = new TextFlowLayout(this);
        }
        return this.layout;
    }

    int getLineCount() {
        return this.textLayout().getLineCount();
    }

    int getLineStartPosition(int charIdx) {
        TwoLevelNavigator navigator = this.textLayout().getTwoLevelNavigator();
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
        return navigator.position(currentLineIndex, 0).toOffset();
    }

    int getLineEndPosition(int charIdx) {
        TwoLevelNavigator navigator = this.textLayout().getTwoLevelNavigator();
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor() + 1;
        int minor = currentLineIndex == this.getLineCount() ? 0 : -1;
        return navigator.position(currentLineIndex, minor).toOffset();
    }

    int getLineOfCharacter(int charIdx) {
        TwoLevelNavigator navigator = this.textLayout().getTwoLevelNavigator();
        return navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
    }

    PathElement[] getCaretShape(int charIdx, boolean isLeading) {
        return this.caretShape(charIdx, isLeading);
    }

    PathElement[] getRangeShape(IndexRange range) {
        return this.getRangeShape(range.getStart(), range.getEnd());
    }

    PathElement[] getRangeShape(int from, int to) {
        return this.rangeShape(from, to);
    }

    PathElement[] getUnderlineShape(IndexRange range) {
        return this.getUnderlineShape(range.getStart(), range.getEnd(), 0.0, 0.0, 0.0);
    }

    PathElement[] getUnderlineShape(int from, int to, double offset, double waveRadius, double doubleGap) {
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        PathElement[] shape = this.rangeShape(from, to);
        boolean doubleLine = doubleGap > 0.0;
        ArrayList<PathElement> result2 = new ArrayList<PathElement>();
        for (int ele = 2; ele < shape.length; ele += 5) {
            LineTo bl = (LineTo)shape[ele + 1];
            LineTo br = (LineTo)shape[ele];
            double y = this.snapSizeY(br.getY() + offset - 2.5);
            double leftx = this.snapSizeX(bl.getX());
            if (waveRadius <= 0.0) {
                result.add(new MoveTo(leftx, y));
                result.add(new LineTo(this.snapSizeX(br.getX()), y));
                if (!doubleLine) continue;
                result2.add(new MoveTo(leftx, y += doubleGap));
                result2.add(new LineTo(this.snapSizeX(br.getX()), y));
                continue;
            }
            double radiusX = waveRadius > 1.0 ? waveRadius * 1.25 : waveRadius;
            double rightx = br.getX();
            result.add(new MoveTo(leftx, y));
            if (doubleLine) {
                result2.add(new MoveTo(leftx, y + doubleGap));
            }
            boolean sweep = true;
            while (leftx < rightx) {
                if ((leftx += waveRadius * 2.0) > rightx) {
                    double dx = rightx - (leftx - waveRadius);
                    double dxsq = dx * dx;
                    double rxsq = radiusX * radiusX;
                    double rysq = waveRadius * waveRadius;
                    double dy = waveRadius * (Math.sqrt(1.0 - dxsq / rxsq) - Math.sqrt(1.0 - rysq / rxsq));
                    y = sweep ? (y -= dy) : (y += dy);
                    leftx = rightx;
                }
                result.add(new ArcTo(radiusX, waveRadius, 0.0, leftx, y, false, sweep));
                if (doubleLine) {
                    result2.add(new ArcTo(radiusX, waveRadius, 0.0, leftx, y + doubleGap, false, sweep));
                }
                sweep = !sweep;
            }
        }
        if (doubleLine) {
            result.addAll(result2);
        }
        return result.toArray(new PathElement[0]);
    }

    CharacterHit hitLine(double x, int lineIndex) {
        return this.hit(x, this.textLayout().getLineCenter(lineIndex));
    }

    CharacterHit hit(double x, double y) {
        TextFlowSpan span = this.textLayout().getLineSpan((float)y);
        Rectangle2D lineBounds = span.getBounds();
        HitInfo hit = this.hitTest(new Point2D(x, y));
        int charIdx = hit.getCharIndex();
        boolean leading = hit.isLeading();
        if (y >= span.getBounds().getMaxY()) {
            return CharacterHit.insertionAt(charIdx);
        }
        if (!leading && this.getLineCount() > 1) {
            boolean bl = leading = this.getLineOfCharacter(charIdx) + 1 < this.getLineCount() && charIdx + 1 >= span.getStart() + span.getLength();
        }
        if (x < lineBounds.getMinX() || x > lineBounds.getMaxX()) {
            if (leading) {
                return CharacterHit.insertionAt(charIdx);
            }
            return CharacterHit.insertionAt(charIdx + 1);
        }
        if (leading) {
            return CharacterHit.leadingHalfOf(charIdx);
        }
        return CharacterHit.trailingHalfOf(charIdx);
    }
}

