/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.animation.Interpolatable;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.reactfx.Change;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.EventStreams;
import org.reactfx.Observable;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import org.reactfx.util.HexaFunction;
import org.reactfx.util.Interpolator;
import org.reactfx.util.PentaFunction;
import org.reactfx.util.TetraFunction;
import org.reactfx.util.TriFunction;
import org.reactfx.value.AnimatedVal;
import org.reactfx.value.ChangeListenerWrapper;
import org.reactfx.value.ConstVal;
import org.reactfx.value.FlatMappedVal;
import org.reactfx.value.FlatMappedVar;
import org.reactfx.value.InvalidationListenerWrapper;
import org.reactfx.value.MappedVal;
import org.reactfx.value.OrElse;
import org.reactfx.value.OrElseConst;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.SuspendableValWrapper;
import org.reactfx.value.ValBase;
import org.reactfx.value.ValWrapper;
import org.reactfx.value.Var;
import org.reactfx.value.VarFromVal;

public interface Val<T>
extends ObservableValue<T>,
Observable<Consumer<? super T>> {
    default public void addInvalidationObserver(Consumer<? super T> observer) {
        this.addObserver(observer);
    }

    default public void removeInvalidationObserver(Consumer<? super T> observer) {
        this.removeObserver(observer);
    }

    default public Subscription observeInvalidations(Consumer<? super T> oldValueObserver) {
        return this.observe(oldValueObserver);
    }

    default public Subscription pin() {
        return this.observeInvalidations(oldVal -> {});
    }

    @Override
    default public void addListener(InvalidationListener listener) {
        this.addInvalidationObserver(new InvalidationListenerWrapper(this, listener));
    }

    @Override
    default public void removeListener(InvalidationListener listener) {
        this.removeInvalidationObserver(new InvalidationListenerWrapper(this, listener));
    }

    @Override
    default public void addListener(ChangeListener<? super T> listener) {
        this.addInvalidationObserver(new ChangeListenerWrapper<T>(this, listener));
    }

    @Override
    default public void removeListener(ChangeListener<? super T> listener) {
        this.removeInvalidationObserver(new ChangeListenerWrapper<T>(this, listener));
    }

    default public Subscription observeChanges(ChangeListener<? super T> listener) {
        return this.observeInvalidations(new ChangeListenerWrapper<T>(this, listener));
    }

    default public EventStream<T> invalidations() {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                return Val.this.observeInvalidations(this::emit);
            }
        };
    }

    default public EventStream<Change<T>> changes() {
        return EventStreams.changesOf(this);
    }

    default public EventStream<T> values() {
        return EventStreams.valuesOf(this);
    }

    default public boolean isPresent() {
        return this.getValue() != null;
    }

    default public boolean isEmpty() {
        return this.getValue() == null;
    }

    default public void ifPresent(Consumer<? super T> f) {
        Object val = this.getValue();
        if (val != null) {
            f.accept(val);
        }
    }

    default public T getOrThrow() {
        Object res = this.getValue();
        if (res != null) {
            return res;
        }
        throw new NoSuchElementException();
    }

    default public T getOrElse(T defaultValue) {
        Object res = this.getValue();
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    default public T getOrSupply(Supplier<? extends T> defaultSupplier) {
        Object res = this.getValue();
        if (res != null) {
            return res;
        }
        return defaultSupplier.get();
    }

    default public Optional<T> getOpt() {
        return Optional.ofNullable(this.getValue());
    }

    default public Val<T> orElseConst(T other) {
        return Val.orElseConst(this, other);
    }

    @Override
    default public Val<T> orElse(ObservableValue<T> other) {
        return Val.orElse(this, other);
    }

    default public Val<T> filter(Predicate<? super T> p) {
        return Val.filter(this, p);
    }

    @Override
    default public <U> Val<U> map(Function<? super T, ? extends U> f) {
        return Val.map(this, f);
    }

    default public <U> Val<U> mapDynamic(ObservableValue<? extends Function<? super T, ? extends U>> f) {
        return Val.mapDynamic(this, f);
    }

    @Override
    default public <U> Val<U> flatMap(Function<? super T, ? extends ObservableValue<U>> f) {
        return Val.flatMap(this, f);
    }

    default public <U> Var<U> selectVar(Function<? super T, ? extends Property<U>> f) {
        return Val.selectVar(this, f);
    }

    default public <U> Var<U> selectVar(Function<? super T, ? extends Property<U>> f, U resetToOnUnbind) {
        return Val.selectVar(this, f, resetToOnUnbind);
    }

    default public Val<T> conditionOn(ObservableValue<Boolean> condition) {
        return Val.conditionOn(this, condition);
    }

    default public Val<T> conditionOnShowing(Node node) {
        return Val.conditionOnShowing(this, node);
    }

    default public SuspendableVal<T> suspendable() {
        return Val.suspendable(this);
    }

    default public Val<T> animate(BiFunction<? super T, ? super T, Duration> duration, Interpolator<T> interpolator) {
        return Val.animate(this, duration, interpolator);
    }

    default public Val<T> animate(Duration duration, Interpolator<T> interpolator) {
        return Val.animate(this, duration, interpolator);
    }

    default public Var<T> asVar(Consumer<T> setValue) {
        return new VarFromVal<T>(this, setValue);
    }

    default public LiveList<T> asList() {
        return LiveList.wrapVal(this);
    }

    public static <T> Val<T> wrap(ObservableValue<T> obs) {
        return obs instanceof Val ? (Val<T>)obs : new ValWrapper(obs);
    }

    public static <T> Subscription observeChanges(ObservableValue<? extends T> obs, ChangeListener<? super T> listener) {
        if (obs instanceof Val) {
            return ((Val)obs).observeChanges(listener);
        }
        obs.addListener(listener);
        return () -> obs.removeListener(listener);
    }

    public static Subscription observeInvalidations(ObservableValue<?> obs, InvalidationListener listener) {
        obs.addListener(listener);
        return () -> obs.removeListener(listener);
    }

    public static <T> Val<T> orElseConst(ObservableValue<? extends T> src, T other) {
        return new OrElseConst<T>(src, other);
    }

    public static <T> Val<T> orElse(ObservableValue<? extends T> src, ObservableValue<? extends T> other) {
        return new OrElse<T>(src, other);
    }

    public static <T> Val<T> filter(ObservableValue<T> src, Predicate<? super T> p) {
        return Val.map(src, t -> p.test(t) ? t : null);
    }

    public static <T, U> Val<U> map(ObservableValue<T> src, Function<? super T, ? extends U> f) {
        return new MappedVal<T, U>(src, f);
    }

    public static <T, U> Val<U> mapDynamic(ObservableValue<T> src, ObservableValue<? extends Function<? super T, ? extends U>> f) {
        return Val.combine(src, f, (t, fn) -> t == null || fn == null ? null : fn.apply(t));
    }

    public static <T, U> Val<U> flatMap(ObservableValue<T> src, Function<? super T, ? extends ObservableValue<U>> f) {
        return new FlatMappedVal(src, f);
    }

    public static <T, U> Var<U> selectVar(ObservableValue<T> src, Function<? super T, ? extends Property<U>> f) {
        return new FlatMappedVar(src, f);
    }

    public static <T, U> Var<U> selectVar(ObservableValue<T> src, Function<? super T, ? extends Property<U>> f, U resetToOnUnbind) {
        return new FlatMappedVar<T, U, Property<U>>(src, f, resetToOnUnbind);
    }

    public static <T> Val<T> conditionOn(ObservableValue<T> obs, ObservableValue<Boolean> condition) {
        return Val.flatMap(condition, con -> con != false ? obs : Val.constant(obs.getValue()));
    }

    public static <T> Val<T> conditionOnShowing(ObservableValue<T> obs, Node node) {
        return Val.conditionOn(obs, Val.showingProperty(node));
    }

    public static <T> SuspendableVal<T> suspendable(ObservableValue<T> obs) {
        if (obs instanceof SuspendableVal) {
            return (SuspendableVal)obs;
        }
        Val<T> val = obs instanceof Val ? (Val<T>)obs : new ValWrapper(obs);
        return new SuspendableValWrapper(val);
    }

    public static <T> Val<T> animate(ObservableValue<T> obs, BiFunction<? super T, ? super T, Duration> duration, Interpolator<T> interpolator) {
        return new AnimatedVal<T>(obs, duration, interpolator);
    }

    public static <T> Val<T> animate(ObservableValue<T> obs, Duration duration, Interpolator<T> interpolator) {
        return Val.animate(obs, (? super T a, ? super T b) -> duration, interpolator);
    }

    public static <T extends Interpolatable<T>> Val<T> animate(ObservableValue<T> obs, BiFunction<? super T, ? super T, Duration> duration) {
        return Val.animate(obs, duration, Interpolator.get());
    }

    public static <T extends Interpolatable<T>> Val<T> animate(ObservableValue<T> obs, Duration duration) {
        return Val.animate(obs, duration, Interpolator.get());
    }

    public static <A, B, R> Val<R> combine(ObservableValue<A> src1, ObservableValue<B> src2, BiFunction<? super A, ? super B, ? extends R> f) {
        return Val.create(() -> {
            if (src1.getValue() != null && src2.getValue() != null) {
                return f.apply((Object)src1.getValue(), (Object)src2.getValue());
            }
            return null;
        }, src1, src2);
    }

    public static <A, B, C, R> Val<R> combine(ObservableValue<A> src1, ObservableValue<B> src2, ObservableValue<C> src3, TriFunction<? super A, ? super B, ? super C, ? extends R> f) {
        return Val.create(() -> {
            if (src1.getValue() != null && src2.getValue() != null && src3.getValue() != null) {
                return f.apply((Object)src1.getValue(), (Object)src2.getValue(), (Object)src3.getValue());
            }
            return null;
        }, src1, src2, src3);
    }

    public static <A, B, C, D, R> Val<R> combine(ObservableValue<A> src1, ObservableValue<B> src2, ObservableValue<C> src3, ObservableValue<D> src4, TetraFunction<? super A, ? super B, ? super C, ? super D, ? extends R> f) {
        return Val.create(() -> {
            if (src1.getValue() != null && src2.getValue() != null && src3.getValue() != null && src4.getValue() != null) {
                return f.apply((Object)src1.getValue(), (Object)src2.getValue(), (Object)src3.getValue(), (Object)src4.getValue());
            }
            return null;
        }, src1, src2, src3, src4);
    }

    public static <A, B, C, D, E, R> Val<R> combine(ObservableValue<A> src1, ObservableValue<B> src2, ObservableValue<C> src3, ObservableValue<D> src4, ObservableValue<E> src5, PentaFunction<? super A, ? super B, ? super C, ? super D, ? super E, ? extends R> f) {
        return Val.create(() -> {
            if (src1.getValue() != null && src2.getValue() != null && src3.getValue() != null && src4.getValue() != null && src5.getValue() != null) {
                return f.apply((Object)src1.getValue(), (Object)src2.getValue(), (Object)src3.getValue(), (Object)src4.getValue(), (Object)src5.getValue());
            }
            return null;
        }, src1, src2, src3, src4, src5);
    }

    public static <A, B, C, D, E, F, R> Val<R> combine(ObservableValue<A> src1, ObservableValue<B> src2, ObservableValue<C> src3, ObservableValue<D> src4, ObservableValue<E> src5, ObservableValue<F> src6, HexaFunction<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? extends R> f) {
        return Val.create(() -> {
            if (src1.getValue() != null && src2.getValue() != null && src3.getValue() != null && src4.getValue() != null && src5.getValue() != null && src6.getValue() != null) {
                return f.apply((Object)src1.getValue(), (Object)src2.getValue(), (Object)src3.getValue(), (Object)src4.getValue(), (Object)src5.getValue(), (Object)src6.getValue());
            }
            return null;
        }, src1, src2, src3, src4, src5, src6);
    }

    public static <T> Val<T> create(final Supplier<? extends T> computeValue, final javafx.beans.Observable ... dependencies) {
        return new ValBase<T>(){

            @Override
            protected Subscription connect() {
                InvalidationListener listener = obs -> this.invalidate();
                for (javafx.beans.Observable dep : dependencies) {
                    dep.addListener(listener);
                }
                return () -> {
                    for (javafx.beans.Observable dep : dependencies) {
                        dep.removeListener(listener);
                    }
                };
            }

            @Override
            protected T computeValue() {
                return computeValue.get();
            }
        };
    }

    public static <T> Val<T> create(final Supplier<? extends T> computeValue, final EventStream<?> invalidations) {
        return new ValBase<T>(){

            @Override
            protected Subscription connect() {
                return invalidations.subscribe((? super T x) -> this.invalidate());
            }

            @Override
            protected T computeValue() {
                return computeValue.get();
            }
        };
    }

    public static <T> Val<T> constant(T value) {
        return new ConstVal<T>(value);
    }

    public static Val<Boolean> showingProperty(Node node) {
        return Val.flatMap(node.sceneProperty(), Scene::windowProperty).flatMap((Function)Window::showingProperty).orElseConst(false);
    }
}

